/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.spring.metadata.SpringStereotypeQualifierMetaData;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.ArrayUtil;

public class SpringResourceProvider
implements StandardResourceProvider,
DefaultLiveTemplatesProvider,
MetaDataContributor {
    public void registerResources(ResourceRegistrar registrar) {
        registrar.addStdResource("http://www.springframework.org/dtd/spring-beans.dtd", "/resources/schemas/spring-beans.dtd", this.getClass());
        registrar.addStdResource("http://www.springframework.org/dtd/spring-beans-2.0.dtd", "/resources/schemas/spring-beans-2.0.dtd", this.getClass());
        this.registerSchema(registrar, "aop", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "beans", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "cache", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "context", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "jdbc", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "jee", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "jms", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "lang", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "task", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "tool", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "tx", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
        this.registerSchema(registrar, "util", "2.0", "2.5", "3.0", "3.1", "3.2", "4.0", "4.1");
    }

    private void registerSchema(ResourceRegistrar registrar, String schemeName, String ... versions) {
        for (String version : versions) {
            String relativePath = schemeName + "/spring-" + schemeName + "-" + version + ".xsd";
            registrar.addStdResource("http://www.springframework.org/schema/" + relativePath, "/resources/schemas/" + relativePath, this.getClass());
        }
    }

    public String[] getDefaultLiveTemplateFiles() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getHiddenLiveTemplateFiles() {
        return new String[]{"/liveTemplates/spring", "/liveTemplates/aop", "/liveTemplates/dataAccess", "/liveTemplates/scheduling", "/liveTemplates/integration", "/liveTemplates/commonBeans", "/liveTemplates/webflow", "/liveTemplates/osgi"};
    }

    public void contributeMetaData(MetaDataRegistrar registrar) {
        registrar.registerMetaData(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                Module module;
                if (element instanceof PsiAnnotation && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
                    for (PsiClass psiClass : JamAnnotationTypeUtil.getInstance((Module)module).getQualifierAnnotationTypesWithChildren()) {
                        PsiAnnotation annotation = (PsiAnnotation)element;
                        if (!Comparing.equal((String)annotation.getQualifiedName(), (String)psiClass.getQualifiedName())) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return PsiAnnotation.class.isAssignableFrom(hintClass);
            }
        }, SpringStereotypeQualifierMetaData.class);
    }
}

