/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMultipleContextsManager {
    private static final FileAttribute CURRENT_SPRING_CONTEXT = new FileAttribute("spring_context", 1, false);

    public static SpringMultipleContextsManager getInstance() {
        return (SpringMultipleContextsManager)ServiceManager.getService(SpringMultipleContextsManager.class);
    }

    @NotNull
    public SpringContextDescriptor getContextDescriptor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getContextDescriptor"));
        }
        if (SpringManagerImpl.isAutoConfigMode()) {
            SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.ALL_CONTEXTS;
            if (springContextDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getContextDescriptor"));
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor cached = this.getCachedContextDescriptor(file);
        if (cached != null) {
            SpringContextDescriptor springContextDescriptor = cached;
            if (springContextDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getContextDescriptor"));
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor descriptor = this.calculateDescriptor(file);
        file.putUserData(SpringContextDescriptor.KEY, (Object)descriptor);
        SpringContextDescriptor springContextDescriptor = descriptor;
        if (springContextDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getContextDescriptor"));
        }
        return springContextDescriptor;
    }

    @Nullable
    public SpringContextDescriptor getCachedContextDescriptor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getCachedContextDescriptor"));
        }
        PsiFile originalFile = file.getOriginalFile();
        return (SpringContextDescriptor)originalFile.getUserData(SpringContextDescriptor.KEY);
    }

    @NotNull
    List<SpringContextDescriptor> getAllContextDescriptors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getAllContextDescriptors"));
        }
        Set modelsByFile = SpringManager.getInstance((Project)psiFile.getProject()).getSpringModelsByFile(psiFile);
        ArrayList<SpringContextDescriptor> descriptors = new ArrayList<SpringContextDescriptor>();
        if (modelsByFile.size() > 1) {
            ArrayList<SpringContextDescriptor> localFileDescriptors = new ArrayList<SpringContextDescriptor>();
            for (SpringModel model : modelsByFile) {
                VirtualFile virtualFile;
                SpringFileSet fileSet = model.getFileSet();
                if (fileSet == null) {
                    List<SpringContextDescriptor> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getAllContextDescriptors"));
                    }
                    return list;
                }
                List files = fileSet.getFiles();
                boolean isLocal = false;
                if (files.size() == 1 && (virtualFile = ((VirtualFilePointer)files.get(0)).getFile()) != null && virtualFile.equals(psiFile.getVirtualFile())) {
                    isLocal = true;
                }
                SpringContextDescriptor descriptor = SpringMultipleContextsManager.createDescriptor(model, fileSet);
                if (isLocal) {
                    localFileDescriptors.add(descriptor);
                    continue;
                }
                descriptors.add(descriptor);
            }
            if (descriptors.size() > 0) {
                descriptors.addAll(localFileDescriptors);
            }
        }
        Collections.sort(descriptors, new Comparator<SpringContextDescriptor>(){

            @Override
            public int compare(SpringContextDescriptor o, SpringContextDescriptor o1) {
                return o.getName().compareTo(o1.getName());
            }
        });
        ArrayList<SpringContextDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getAllContextDescriptors"));
        }
        return arrayList;
    }

    private static SpringContextDescriptor createDescriptor(@NotNull SpringModel model, @NotNull SpringFileSet fileSet) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "createDescriptor"));
        }
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "createDescriptor"));
        }
        final String qualifiedName = fileSet.getQualifiedName();
        return new SpringContextDescriptor(model.getModule(), fileSet.getId(), fileSet.getName()){

            @NotNull
            public String getQualifiedName() {
                String string = qualifiedName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager$2", "getQualifiedName"));
                }
                return string;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistDescriptor(@NotNull PsiFile file, @NotNull SpringContextDescriptor descriptor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "persistDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "persistDescriptor"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile.isDirectory()) {
            return;
        }
        file.putUserData(SpringContextDescriptor.KEY, (Object)descriptor);
        String id = descriptor.getQualifiedName();
        DataOutputStream outputStream = CURRENT_SPRING_CONTEXT.writeAttribute(virtualFile);
        try {
            try {
                outputStream.writeUTF(StringUtil.notNullize((String)id));
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileBasedIndex.getInstance().requestReindex(virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPersistedDescriptor(@NotNull PsiFile file) {
        block7: {
            String string;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "getPersistedDescriptor"));
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || virtualFile.isDirectory()) {
                return null;
            }
            DataInputStream inputStream = CURRENT_SPRING_CONTEXT.readAttribute(virtualFile);
            if (inputStream == null) break block7;
            try {
                string = inputStream.readUTF();
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
            return string;
        }
        return null;
    }

    @NotNull
    private SpringContextDescriptor calculateDescriptor(@NotNull PsiFile file) {
        Module currentModule;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
        }
        List<SpringContextDescriptor> descriptors = this.getAllContextDescriptors(file);
        String qualifiedName = SpringMultipleContextsManager.getPersistedDescriptor(file);
        if (qualifiedName != null) {
            if (qualifiedName.equals(SpringContextDescriptor.LOCAL_CONTEXT.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.LOCAL_CONTEXT;
                if (springContextDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
                }
                return springContextDescriptor;
            }
            if (qualifiedName.equals(SpringContextDescriptor.ALL_CONTEXTS.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.ALL_CONTEXTS;
                if (springContextDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
                }
                return springContextDescriptor;
            }
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!qualifiedName.equals(descriptor.getQualifiedName())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
                }
                return springContextDescriptor;
            }
        }
        if ((currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!currentModule.equals(descriptor.getModule())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
                }
                return springContextDescriptor;
            }
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.DEFAULT;
        if (springContextDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager", "calculateDescriptor"));
        }
        return springContextDescriptor;
    }
}

