/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.diagram.actions.OpenSpringModelDependenciesAction;
import com.intellij.spring.contexts.model.diagram.actions.OpenSpringModelDependenciesModuleDiagramAction;
import com.intellij.ui.awt.RelativePoint;
import icons.SpringCoreIcons;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalModelDependenciesAnnotator
implements Annotator {
    public final void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesAnnotator", "annotate"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.doAnnotate(element, holder);
    }

    protected abstract void doAnnotate(PsiElement var1, AnnotationHolder var2);

    protected static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final LocalModel myModel;

        protected MyGutterIconRenderer(@NotNull LocalModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesAnnotator$MyGutterIconRenderer", "<init>"));
            }
            this.myModel = model;
        }

        @Nullable
        public String getTooltipText() {
            return SpringBundle.message("local.model.dependencies.diagram.title", new Object[0]);
        }

        @Nullable
        public AnAction getClickAction() {
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add((AnAction)new OpenSpringModelDependenciesModuleDiagramAction());
                    group.add((AnAction)new OpenSpringModelDependenciesAction());
                    DataContext context = SimpleDataContext.getProjectContext(null);
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                    popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
                }
            };
        }

        public boolean isNavigateAction() {
            return true;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = SpringCoreIcons.SpringModelsDependencyGraph;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesAnnotator$MyGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyGutterIconRenderer renderer = (MyGutterIconRenderer)((Object)o);
            return this.myModel.equals(renderer.myModel);
        }

        public int hashCode() {
            return this.myModel.getConfig().hashCode();
        }
    }
}

