/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.annotator;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.diagram.annotator.LocalModelDependenciesAnnotator;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public class LocalModelDependenciesJavaAnnotator
extends LocalModelDependenciesAnnotator {
    @Override
    public void doAnnotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesJavaAnnotator", "doAnnotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesJavaAnnotator", "doAnnotate"));
        }
        if (!(element instanceof PsiClass)) {
            return;
        }
        if (!SpringCommonUtils.hasSpringLibrary((Project)element.getProject())) {
            return;
        }
        PsiClass psiClass = (PsiClass)element;
        if (!SpringConfiguration.PSI_CLASS_PATTERN.accepts((Object)psiClass)) {
            return;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (boolean)true, (String[])new String[]{"org.springframework.context.annotation.Configuration"});
        if (annotation == null) {
            return;
        }
        LocalAnnotationModel localAnnotationModel = SpringManager.getInstance((Project)psiClass.getProject()).getLocalSpringModel(psiClass);
        if (localAnnotationModel == null) {
            return;
        }
        Annotation infoAnnotation = holder.createInfoAnnotation((PsiElement)annotation, null);
        infoAnnotation.setGutterIconRenderer((GutterIconRenderer)new LocalModelDependenciesAnnotator.MyGutterIconRenderer((LocalModel)localAnnotationModel));
    }
}

