/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.annotator;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.annotator.LocalModelDependenciesAnnotator;
import com.intellij.spring.dom.SpringDomUtils;
import org.jetbrains.annotations.NotNull;

public class LocalModelDependenciesXmlAnnotator
extends LocalModelDependenciesAnnotator {
    @Override
    public void doAnnotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesXmlAnnotator", "doAnnotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/contexts/model/diagram/annotator/LocalModelDependenciesXmlAnnotator", "doAnnotate"));
        }
        if (element instanceof XmlTag && "beans".equals(((XmlTag)element).getLocalName()) && ((XmlTag)element).getParentTag() == null) {
            PsiFile file = element.getContainingFile();
            if (!(file instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)file;
            if (!SpringDomUtils.isSpringXml((XmlFile)xmlFile)) {
                return;
            }
            LocalXmlModel model = SpringManager.getInstance((Project)file.getProject()).getLocalSpringModel(xmlFile);
            if (model != null) {
                Annotation infoAnnotation = holder.createInfoAnnotation(element, null);
                infoAnnotation.setGutterIconRenderer((GutterIconRenderer)new LocalModelDependenciesAnnotator.MyGutterIconRenderer((LocalModel)model));
            }
        }
    }
}

