/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAnnotationModelWrapper
extends LocalModelWrapper<LocalAnnotationModel> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LocalAnnotationModelWrapper.class.getName()));

    LocalAnnotationModelWrapper(@NotNull LocalAnnotationModel element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/beans/LocalAnnotationModelWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    protected void addImportsInformation(StringBuilder sb) {
        PsiClass psiClass = (PsiClass)((LocalAnnotationModel)this.myElement).getConfig();
        LocalAnnotationModelWrapper.addTr(sb, "Imported Resources", SpringJamUtils.getInstance().getImportedResources(psiClass).size());
        LocalAnnotationModelWrapper.addTr(sb, "Imported Configurations", SpringJamUtils.getInstance().getImportedClasses(psiClass, null).size());
    }

    @Override
    @NotNull
    protected String getLocalModelQualifiedName() {
        PsiClass config = (PsiClass)((LocalAnnotationModel)this.myElement).getConfig();
        String name = config.getQualifiedName();
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalAnnotationModelWrapper", "getLocalModelQualifiedName"));
            }
            return string;
        }
        if (config instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousConfig = (PsiAnonymousClass)config;
            LOG.warn(String.format("Anonymous class with base class '%s' contatined in class '%s' is considered a local model", anonymousConfig.getBaseClassType().getClassName(), anonymousConfig.getContainingClass()));
        } else if (config instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameterConfig = (PsiTypeParameter)config;
            LOG.warn(String.format("Type parameter '%s' is considered a local model", typeParameterConfig.toString()));
        } else {
            LOG.warn(String.format("Config '%s' doesn't have a qualified name and is not PsiAnonymousClass nor PsiTypeParameter", config.toString()));
        }
        if ("???" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalAnnotationModelWrapper", "getLocalModelQualifiedName"));
        }
        return "???";
    }

    @Override
    public String getTitle() {
        return ((PsiClass)((LocalAnnotationModel)this.myElement).getConfig()).getName();
    }

    @Override
    public String getQualifiedName() {
        return ((PsiClass)((LocalAnnotationModel)this.myElement).getConfig()).getQualifiedName();
    }

    @Nullable
    public static LocalAnnotationModelWrapper create(@Nullable LocalAnnotationModel element) {
        return element == null ? null : new LocalAnnotationModelWrapper(element);
    }

    @Nullable
    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (aClass != null) {
            return LocalAnnotationModelWrapper.create(SpringManager.getInstance((Project)project).getLocalSpringModel(aClass));
        }
        return null;
    }
}

