/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.extras;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalAnnotationModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalXmlModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.ui.SimpleColoredText;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsDiagramElementManager
extends AbstractDiagramElementManager<LocalModelGraphElementWrapper> {
    public LocalModelGraphElementWrapper findInDataContext(DataContext context) {
        PsiClass[] classes;
        LocalModel model = SpringLocalModelsDiagramElementManager.findPsiClass((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context));
        if (model != null) {
            return LocalModelWrapper.create(model);
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            return LocalXmlModelWrapper.create(SpringManager.getInstance((Project)psiFile.getProject()).getLocalSpringModel((XmlFile)psiFile));
        }
        if (psiFile instanceof PsiJavaFile && (classes = ((PsiJavaFile)psiFile).getClasses()).length == 1) {
            return LocalAnnotationModelWrapper.create(SpringManager.getInstance((Project)psiFile.getProject()).getLocalSpringModel(classes[0]));
        }
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module != null) {
            Project project = module.getProject();
            VirtualFile moduleFolder = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            if (moduleFolder != null && ProjectRootsUtil.isModuleContentRoot((VirtualFile)moduleFolder, (Project)project) && SpringFacet.getInstance((Module)module) != null) {
                return ModuleLocalModelWrapper.create(module);
            }
        }
        return null;
    }

    @Nullable
    private static LocalModel findPsiClass(@Nullable PsiElement element) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass != null) {
            return SpringManager.getInstance((Project)psiClass.getProject()).getLocalSpringModel(psiClass);
        }
        return null;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof LocalModelGraphElementWrapper;
    }

    public String getElementTitle(LocalModelGraphElementWrapper model) {
        return SpringLocalModelsDiagramElementManager.getLocalModelConfigFileName(model);
    }

    private static String getLocalModelConfigFileName(LocalModelGraphElementWrapper model) {
        return model.getTitle();
    }

    public SimpleColoredText getItemName(Object obj, DiagramState presentation) {
        if (obj instanceof LocalModelGraphElementWrapper) {
            return new SimpleColoredText(SpringLocalModelsDiagramElementManager.getLocalModelConfigFileName((LocalModelGraphElementWrapper)obj), DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    public String getNodeTooltip(LocalModelGraphElementWrapper element) {
        return element.getToolTip();
    }

    public Icon getItemIcon(Object model, DiagramState presentation) {
        if (model instanceof LocalAnnotationModel) {
            return ((PsiClass)((LocalAnnotationModel)model).getConfig()).getIcon(0);
        }
        if (model instanceof LocalXmlModel) {
            return ((XmlFile)((LocalXmlModel)model).getConfig()).getIcon(0);
        }
        return SpringApiIcons.Spring;
    }
}

