/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.xml.beans.CNamespaceRefValue;
import com.intellij.spring.model.xml.beans.CNamespaceValue;
import com.intellij.spring.model.xml.beans.PNamespaceRefValue;
import com.intellij.spring.model.xml.beans.PNamespaceValue;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import org.jetbrains.annotations.NotNull;

public abstract class SpringXNamespaceDomExtender
extends DomExtender<SpringBean> {
    private final String myNamespace;
    private final String myNamespaceKey;
    private final Class<?> myValueClass;
    private final Class<?> myRefValueClass;

    protected SpringXNamespaceDomExtender(String namespace, String namespaceKey, Class<?> valueClass, Class<?> refValueClass) {
        this.myNamespace = namespace;
        this.myNamespaceKey = namespaceKey;
        this.myValueClass = valueClass;
        this.myRefValueClass = refValueClass;
    }

    public void registerExtensions(@NotNull SpringBean bean, @NotNull DomExtensionsRegistrar registrar) {
        XmlAttribute[] attributes;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/dom/SpringXNamespaceDomExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/dom/SpringXNamespaceDomExtender", "registerExtensions"));
        }
        XmlTag tag = bean.getXmlTag();
        if (tag == null || tag.getPrefixByNamespace(this.myNamespace) == null) {
            return;
        }
        for (XmlAttribute attribute : attributes = tag.getAttributes()) {
            if (!this.myNamespace.equals(attribute.getNamespace())) continue;
            String name = attribute.getLocalName();
            registrar.registerAttributeChildExtension(new XmlName(name, this.myNamespaceKey), name.endsWith("-ref") ? this.myRefValueClass : this.myValueClass);
        }
    }

    public static class C
    extends SpringXNamespaceDomExtender {
        public C() {
            super("http://www.springframework.org/schema/c", "Spring c-namespace", CNamespaceValue.class, CNamespaceRefValue.class);
        }
    }

    public static class P
    extends SpringXNamespaceDomExtender {
        public P() {
            super("http://www.springframework.org/schema/p", "Spring p-namespace", PNamespaceValue.class, PNamespaceRefValue.class);
        }
    }
}

