/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.namespaces;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.namespaces.AbstractSpringBeanNamespaceDescriptor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import org.jetbrains.annotations.NotNull;

public class PNamespaceUndefinedElementFixProvider
extends XmlUndefinedElementFixProvider {
    public IntentionAction[] createFixes(@NotNull XmlAttribute element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/dom/namespaces/PNamespaceUndefinedElementFixProvider", "createFixes"));
        }
        PsiClass psiClass = AbstractSpringBeanNamespaceDescriptor.getClass(element.getParent());
        if (psiClass != null) {
            String name;
            PsiClassType type = null;
            String localName = element.getLocalName();
            Project project = element.getProject();
            if (localName.endsWith("-ref")) {
                SpringBeanPointer pointer;
                SpringModel model = SpringManager.getInstance((Project)project).getSpringModelByFile(element.getContainingFile());
                String value = element.getDisplayValue();
                if (model != null && value != null && (pointer = SpringBeanUtils.getInstance().findBean((CommonSpringModel)model, value)) != null && pointer.getEffectiveBeanType().length > 0) {
                    type = PsiTypesUtil.getClassType((PsiClass)pointer.getEffectiveBeanType()[0]);
                }
            }
            if ((name = element.getLocalName()).endsWith("-ref")) {
                name = name.substring(0, name.length() - "-ref".length());
            }
            return CreateBeanPropertyFix.createActions((String)name, (PsiClass)psiClass, type, (boolean)true);
        }
        return null;
    }
}

