/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.facet.Facet;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpringConfigurationCheckStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/SpringConfigurationCheckStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        try {
            Boolean hasSpringSupport = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return SpringCommonUtils.hasSpringLibrary((Project)project);
                }
            });
            if (!hasSpringSupport.booleanValue()) {
                return;
            }
            final DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
            if (((Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return detectionExcludesConfiguration.isExcludedFromDetection(SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE);
                }
            })).booleanValue()) {
                return;
            }
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)project);
            if (profileManager.isProfileLoaded()) {
                SpringConfigurationCheckStartupActivity.queueTask(project);
                return;
            }
            profileManager.addProfilesListener(new ProfileChangeAdapter(){

                public void profilesInitialized() {
                    SpringConfigurationCheckStartupActivity.queueTask(project);
                }
            }, (Disposable)project);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static void queueTask(final Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new SpringConfigurationCheckTask(project).queue();
            }
        }, project.getDisposed());
    }

    private static class SpringConfigurationCheckTask
    extends Task.Backgroundable {
        private static final String NOTIFICATION_ID = "Spring Configuration Check";
        private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Spring Configuration Check", NotificationDisplayType.STICKY_BALLOON, true);
        private final DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        private SpringUnmappedConfigurationFilesCollector myUnmappedCollector;
        private SpringProgrammaticConfigurationCollector myProgrammaticCollector;

        private SpringConfigurationCheckTask(Project project) {
            super(project, "Checking Spring Configuration...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            SensitiveProgressWrapper innerIndicator;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/spring/facet/SpringConfigurationCheckStartupActivity$SpringConfigurationCheckTask", "run"));
            }
            do {
                innerIndicator = SpringConfigurationCheckTask.createWrappingIndicator(indicator);
                Disposable disposable = Disposer.newDisposable();
                try {
                    SwingUtilities.invokeAndWait(new Runnable((ProgressIndicator)innerIndicator, disposable){
                        final /* synthetic */ ProgressIndicator val$innerIndicator;
                        final /* synthetic */ Disposable val$disposable;
                        {
                            this.val$innerIndicator = progressIndicator;
                            this.val$disposable = disposable;
                        }

                        @Override
                        public void run() {
                            ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)this.val$innerIndicator, (Disposable)this.val$disposable);
                        }
                    });
                }
                catch (Throwable e) {
                    break;
                }
                try {
                    ProgressManager.getInstance().runProcess(new Runnable((ProgressIndicator)innerIndicator){
                        final /* synthetic */ ProgressIndicator val$innerIndicator;
                        {
                            this.val$innerIndicator = progressIndicator;
                        }

                        @Override
                        public void run() {
                            try {
                                SpringConfigurationCheckTask.this.dumbService.runReadActionInSmartMode(new Runnable(){

                                    @Override
                                    public void run() {
                                        SpringConfigurationCheckTask.this.runCollectors(val$innerIndicator);
                                    }
                                });
                            }
                            catch (ProcessCanceledException processCanceledException) {
                                // empty catch block
                            }
                        }
                    }, (ProgressIndicator)innerIndicator);
                }
                finally {
                    Disposer.dispose((Disposable)disposable);
                }
            } while (!indicator.isCanceled() && innerIndicator.isCanceled());
        }

        private static SensitiveProgressWrapper createWrappingIndicator(final ProgressIndicator indicator) {
            return new SensitiveProgressWrapper(indicator){

                public void setText(String text) {
                    indicator.setText(text);
                }

                public void setText2(String text) {
                    indicator.setText2(text);
                }

                public void setFraction(double fraction) {
                    indicator.setFraction(fraction);
                }

                public void setIndeterminate(boolean indeterminate) {
                    indicator.setIndeterminate(indeterminate);
                }
            };
        }

        private void runCollectors(ProgressIndicator indicator) {
            if (this.getProject().isDisposed()) {
                return;
            }
            Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
            if (modules.length == 0) {
                return;
            }
            this.myUnmappedCollector = new SpringUnmappedConfigurationFilesCollector(modules);
            if (this.myUnmappedCollector.isEnabledInProject()) {
                this.myUnmappedCollector.collect(indicator);
            }
            this.myProgrammaticCollector = new SpringProgrammaticConfigurationCollector(this.getProject());
            if (!ApplicationManager.getApplication().isInternal()) {
                return;
            }
            if (this.myProgrammaticCollector.isEnabledInProject()) {
                this.myProgrammaticCollector.collect(indicator);
            }
        }

        public void onSuccess() {
            if (this.getProject().isDisposed()) {
                return;
            }
            if (this.myUnmappedCollector == null || this.myProgrammaticCollector == null) {
                return;
            }
            final List<PsiElement> programmaticResults = this.myProgrammaticCollector.getResults();
            if (!this.myUnmappedCollector.hasResults() && programmaticResults.isEmpty()) {
                return;
            }
            final MultiMap unmappedFilesCount = MultiMap.create();
            String notification = "";
            if (this.myUnmappedCollector.hasResults()) {
                notification = notification + "Unmapped Spring configuration files found. <a href=\"#disableAll\">Disable...</a><br/><br/>Please configure/setup Spring facet for modules:<br/>";
                Processor<PsiFile> fileTypeCounterProcessor = new Processor<PsiFile>(){

                    public boolean process(PsiFile psiFile) {
                        unmappedFilesCount.putValue((Object)psiFile.getFileType().getDefaultExtension(), (Object)psiFile);
                        return true;
                    }
                };
                for (Pair<Module, Collection<PsiFile>> entry : this.myUnmappedCollector.getModulesWithUnmappedFiles()) {
                    String moduleName = ((Module)entry.getFirst()).getName();
                    Collection files = (Collection)entry.getSecond();
                    int filesCount = files.size();
                    notification = notification + "<a href=\"config#" + moduleName + "\">" + moduleName + "</a>";
                    notification = notification + " (<a href=\"files#" + moduleName + "\">" + filesCount + " " + StringUtil.pluralize((String)"file", (int)filesCount) + "</a>)<br/>";
                    ContainerUtil.process((Iterable)files, (Processor)fileTypeCounterProcessor);
                }
            }
            if (!programmaticResults.isEmpty()) {
                notification = notification + (!notification.isEmpty() ? "<br/>" : "") + "Programmatic contexts found:<br/>";
                for (int i = 0; i < programmaticResults.size(); ++i) {
                    PsiElement psiElement = programmaticResults.get(i);
                    PsiFile psiFile = psiElement.getContainingFile();
                    notification = notification + "<a href=\"psi#" + i + "\">" + psiFile.getName() + "</a><br/>";
                    unmappedFilesCount.putValue((Object)(psiFile.getFileType().getDefaultExtension() + ".Programmatic"), (Object)psiFile);
                }
            }
            for (Map.Entry entry : unmappedFilesCount.entrySet()) {
                String configFileTypeKey = (String)entry.getKey();
                for (int i = 0; i < ((Collection)entry.getValue()).size(); ++i) {
                    UsageTrigger.trigger((String)("spring.SpringConfigurationCheck.FileCount." + configFileTypeKey));
                }
            }
            NOTIFICATION_GROUP.createNotification(NOTIFICATION_ID, notification, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    int result;
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/spring/facet/SpringConfigurationCheckStartupActivity$SpringConfigurationCheckTask$5", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/facet/SpringConfigurationCheckStartupActivity$SpringConfigurationCheckTask$5", "hyperlinkActivated"));
                    }
                    if (SpringConfigurationCheckTask.this.getProject().isDisposed()) {
                        return;
                    }
                    String description = e.getDescription();
                    String navigationTarget = StringUtil.substringAfter((String)description, (String)"#");
                    assert (navigationTarget != null);
                    if (description.startsWith("config")) {
                        Module module = ModuleManager.getInstance((Project)SpringConfigurationCheckTask.this.getProject()).findModuleByName(navigationTarget);
                        if (module == null) {
                            return;
                        }
                        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
                        if (springFacet != null) {
                            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                        } else {
                            ModulesConfigurator.showDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)navigationTarget, null);
                        }
                    } else if (description.startsWith("files")) {
                        Module module = ModuleManager.getInstance((Project)SpringConfigurationCheckTask.this.getProject()).findModuleByName(navigationTarget);
                        if (module == null) {
                            return;
                        }
                        Collection<PsiFile> files = SpringConfigurationCheckTask.this.myUnmappedCollector.getUnmappedFilesFor(module);
                        if (files.size() == 1) {
                            NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)files.iterator().next()));
                            return;
                        }
                        JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])ArrayUtil.toObjectArray(files, PsiFile.class)), (String)("Unmapped Spring Configuration Files in " + navigationTarget));
                        Object event = e.getSource();
                        if (event instanceof Component) {
                            popup.showInCenterOf((Component)event);
                        } else {
                            popup.showInFocusCenter();
                        }
                    } else if (description.startsWith("psi")) {
                        PsiElement element = (PsiElement)programmaticResults.get(Integer.parseInt(navigationTarget));
                        NavigationUtil.activateFileWithPsiElement((PsiElement)element);
                    } else if (description.equals("#disableAll") && (result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)"Detection will be disabled for whole project.\nProject Structure | Facets | Detection\ncan be used to exclude specific files/folders only and to re-enable.", (String)"Spring Config Detection", (String)"Disable Detection", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 0) {
                        DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                        detectionExcludesConfiguration.addExcludedFramework(SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE);
                        notification.hideBalloon();
                    }
                }
            }).notify(this.getProject());
        }
    }
}

