/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.impl.ui.FacetEditorsFactoryImpl;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTab;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.library.SpringLibraryType;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringFacetConfigurationImpl
extends SimpleModificationTracker
implements SpringFacetConfiguration {
    @NonNls
    private static final String FILESET = "fileset";
    @NonNls
    private static final String SET_ID = "id";
    @NonNls
    private static final String ACTIVE_PROFILES = "profiles";
    @NonNls
    private static final String SET_NAME = "name";
    @NonNls
    private static final String SET_REMOVED = "removed";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String DEPENDENCY = "dependency";
    @NonNls
    private static final String AUTODETECTED = "autodetected";
    private final Set<SpringFileSetData> myFileSets = new LinkedHashSet<SpringFileSetData>();
    private final NotNullLazyValue<Set<CustomSetting>> myCustomSettings = new AtomicNotNullLazyValue<Set<CustomSetting>>(){

        @NotNull
        protected Set<CustomSetting> compute() {
            LinkedHashSet<CustomSetting> myCustomSettings = new LinkedHashSet<CustomSetting>();
            myCustomSettings.add((CustomSetting)new CustomSetting.BOOLEAN("process_explicitly_annotated", SpringBundle.message("process.explicitly.annotated.beans", new Object[0]), true));
            LinkedHashSet<CustomSetting> linkedHashSet = myCustomSettings;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFacetConfigurationImpl$1", "compute"));
            }
            return linkedHashSet;
        }
    };
    private final SortedMap<String, String> myAutodetectedFileSetProfiles = new TreeMap<String, String>();

    @NotNull
    Set<SpringFileSetData> getFileSetDescriptors() {
        Set<SpringFileSetData> set = Collections.unmodifiableSet(this.myFileSets);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "getFileSetDescriptors"));
        }
        return set;
    }

    boolean addSpringFileSetData(@NotNull SpringFileSetData fileSet) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "addSpringFileSetData"));
        }
        return this.myFileSets.add(fileSet);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        FrameworkLibraryValidator validator = FacetEditorsFactoryImpl.getInstanceImpl().createLibraryValidator(DownloadableLibraryService.getInstance().createDescriptionForType(SpringLibraryType.class), editorContext, validatorsManager, "spring");
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        return new FacetEditorTab[]{new SpringConfigurationTab(editorContext, validatorsManager)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(Element element) throws InvalidDataException {
        for (Object setElement : element.getChildren(FILESET)) {
            Object dep2;
            String auto = ((Element)setElement).getAttributeValue(AUTODETECTED);
            if (auto != null && Boolean.parseBoolean(auto)) {
                String setId = ((Element)setElement).getAttributeValue(SET_ID);
                String activeProfiles = ((Element)setElement).getAttributeValue(ACTIVE_PROFILES);
                if (setId == null || activeProfiles == null) continue;
                SortedMap<String, String> sortedMap = this.myAutodetectedFileSetProfiles;
                synchronized (sortedMap) {
                    this.myAutodetectedFileSetProfiles.put(setId, activeProfiles);
                    continue;
                }
            }
            String setName = ((Element)setElement).getAttributeValue(SET_NAME);
            String setId = ((Element)setElement).getAttributeValue(SET_ID);
            String removed = ((Element)setElement).getAttributeValue(SET_REMOVED);
            if (setName == null || setId == null) continue;
            SpringFileSetData fileSet = SpringFileSetData.create((String)setId, (String)setName);
            List deps = ((Element)setElement).getChildren(DEPENDENCY);
            for (Object dep2 : deps) {
                fileSet.addDependency(((Element)dep2).getText());
            }
            List files = ((Element)setElement).getChildren(FILE);
            dep2 = files.iterator();
            while (dep2.hasNext()) {
                Object fileElement = dep2.next();
                String text = ((Element)fileElement).getText();
                fileSet.addFile(text);
            }
            fileSet.setRemoved(Boolean.valueOf(removed).booleanValue());
            this.myFileSets.add(fileSet);
            String activeProfiles = ((Element)setElement).getAttributeValue(ACTIVE_PROFILES);
            if (!StringUtil.isNotEmpty((String)activeProfiles)) continue;
            fileSet.setActiveProfiles((Set)new HashSet((Collection)StringUtil.split((String)activeProfiles, (String)",")));
        }
        for (CustomSetting settingBean : this.getCustomSettings()) {
            String name = settingBean.getName();
            String s = element.getAttributeValue(name);
            if (s == null) continue;
            settingBean.setStringValue(s);
            settingBean.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Element element) throws WriteExternalException {
        for (SpringFileSetData fileSet : this.myFileSets) {
            Element setElement = new Element(FILESET);
            setElement.setAttribute(SET_ID, fileSet.getId());
            setElement.setAttribute(SET_NAME, fileSet.getName());
            setElement.setAttribute(SET_REMOVED, Boolean.toString(fileSet.isRemoved()));
            element.addContent(setElement);
            for (String dep : fileSet.getDependencies()) {
                Element depElement = new Element(DEPENDENCY);
                depElement.setText(dep);
                setElement.addContent(depElement);
            }
            for (String url : fileSet.getFiles()) {
                Element fileElement = new Element(FILE);
                fileElement.setText(url);
                setElement.addContent(fileElement);
            }
            Set activeProfiles = fileSet.getActiveProfiles();
            if (activeProfiles.size() <= 0) continue;
            setElement.setAttribute(ACTIVE_PROFILES, StringUtil.join((Collection)activeProfiles, (String)","));
        }
        for (CustomSetting customSetting : this.getCustomSettings()) {
            if (customSetting.getStringValue() == null) continue;
            element.setAttribute(customSetting.getName(), customSetting.getStringValue());
        }
        SortedMap<String, String> sortedMap = this.myAutodetectedFileSetProfiles;
        synchronized (sortedMap) {
            for (Map.Entry<String, String> entry : this.myAutodetectedFileSetProfiles.entrySet()) {
                if (!StringUtil.isNotEmpty((String)entry.getValue())) continue;
                Element setElement = new Element(FILESET);
                setElement.setAttribute(SET_ID, entry.getKey());
                setElement.setAttribute(ACTIVE_PROFILES, entry.getValue());
                setElement.setAttribute(AUTODETECTED, "true");
                element.addContent(setElement);
            }
        }
    }

    public void setModified() {
        this.incModificationCount();
    }

    public void dispose() {
    }

    public synchronized void registerAutodetectedFileSet(@NotNull SpringFileSet fileset) {
        if (fileset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILESET, "com/intellij/spring/facet/SpringFacetConfigurationImpl", "registerAutodetectedFileSet"));
        }
        String id = fileset.getId();
        if (!this.myAutodetectedFileSetProfiles.containsKey(id)) {
            this.myAutodetectedFileSetProfiles.put(id, "");
        }
        fileset.setActiveProfiles(this.getActiveProfiles(id));
    }

    public synchronized void setActiveProfilesForAutodetected(@NotNull String filesetId, @NotNull Set<String> profiles) {
        if (filesetId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesetId", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "setActiveProfilesForAutodetected"));
        }
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTIVE_PROFILES, "com/intellij/spring/facet/SpringFacetConfigurationImpl", "setActiveProfilesForAutodetected"));
        }
        this.myAutodetectedFileSetProfiles.put(filesetId, StringUtil.join(profiles, (String)","));
    }

    @NotNull
    private synchronized Set<String> getActiveProfiles(@NotNull String filesetId) {
        if (filesetId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesetId", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "getActiveProfiles"));
        }
        String profiles = (String)this.myAutodetectedFileSetProfiles.get(filesetId);
        HashSet hashSet = StringUtil.isEmptyOrSpaces((String)profiles) ? new HashSet() : new HashSet((Collection)StringUtil.split((String)profiles, (String)","));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "getActiveProfiles"));
        }
        return hashSet;
    }

    void removeFileSetDescriptors() {
        this.myFileSets.clear();
    }

    @NotNull
    public Set<CustomSetting> getCustomSettings() {
        Set set = (Set)this.myCustomSettings.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFacetConfigurationImpl", "getCustomSettings"));
        }
        return set;
    }
}

