/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTypeResolver
implements ObjectTypeResolver {
    @NonNls
    private static final String CLASS_ARRAY_EDITOR_SEPARATOR = ",";

    @Nullable
    protected static String getPropertyValue(@Nullable CommonSpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition property;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getPropertyValue"));
        }
        if (bean instanceof SpringBean && (property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName)) != null) {
            return property.getValueAsString();
        }
        return null;
    }

    @NotNull
    protected static Set<String> getListOrSetValues(@NotNull SpringBean bean, @NotNull String propertyName) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getListOrSetValues"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getListOrSetValues"));
        }
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName);
        if (property instanceof SpringProperty) {
            Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getListOrSetValues"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getListOrSetValues"));
        }
        return set;
    }

    @NotNull
    protected static Set<String> getTypesFromClassArrayProperty(@NotNull SpringBean context, String propertyName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypesFromClassArrayProperty"));
        }
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName);
        if (property != null) {
            String stringValue = property.getValueAsString();
            if (stringValue != null) {
                Set<String> set = AbstractTypeResolver.splitAndTrim(stringValue, CLASS_ARRAY_EDITOR_SEPARATOR);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypesFromClassArrayProperty"));
                }
                return set;
            }
            if (property instanceof SpringProperty) {
                Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypesFromClassArrayProperty"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypesFromClassArrayProperty"));
        }
        return set;
    }

    @NotNull
    private static Set<String> splitAndTrim(@NotNull String value, @NotNull String separator) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "splitAndTrim"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "splitAndTrim"));
        }
        List parts = StringUtil.split((String)value, (String)separator);
        HashSet<String> trimmedParts = new HashSet<String>(parts.size());
        for (String part : parts) {
            trimmedParts.add(part.trim());
        }
        HashSet<String> hashSet = trimmedParts;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "splitAndTrim"));
        }
        return hashSet;
    }

    protected static boolean isBooleanPropertySetAndTrue(@NotNull SpringBean context, @NotNull String propertyName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "isBooleanPropertySetAndTrue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "isBooleanPropertySetAndTrue"));
        }
        String value = AbstractTypeResolver.getPropertyValue((CommonSpringBean)context, propertyName);
        return value != null && BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    protected static boolean isBooleanPropertySetAndFalse(@NotNull SpringBean context, @NotNull String propertyName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "isBooleanPropertySetAndFalse"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "isBooleanPropertySetAndFalse"));
        }
        String value = AbstractTypeResolver.getPropertyValue((CommonSpringBean)context, propertyName);
        return value != null && !BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    @Nullable
    protected static PsiClassType getTypeFromProperty(@NotNull SpringBean context, @NotNull String propertyName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypeFromProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypeFromProperty"));
        }
        SpringPropertyDefinition targetProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName);
        if (targetProperty != null) {
            SpringProperty property;
            SpringBean bean;
            if (targetProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = (property = (SpringProperty)targetProperty).getBean()))) {
                PsiClass[] classes = BeanService.getInstance().getEffectiveBeanTypes((CommonSpringBean)bean);
                PsiManager psiManager = bean.getPsiManager();
                if (classes.length > 0 && psiManager != null) {
                    return JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(classes[0]);
                }
            }
            return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringPropertyUtils.findReferencedBean((SpringPropertyDefinition)targetProperty));
        }
        return null;
    }

    @Nullable
    protected static PsiClassType getTypeFromBeanName(@NotNull SpringBean context, @NotNull String beanName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypeFromBeanName"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/factories/resolvers/AbstractTypeResolver", "getTypeFromBeanName"));
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)context);
        return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName));
    }

    @Nullable
    private static PsiClassType getTypeFromNonFactoryBean(@Nullable SpringBeanPointer bean) {
        PsiClass targetBeanClass;
        if (bean != null && (targetBeanClass = bean.getBeanClass()) != null && !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(targetBeanClass)) {
            return PsiTypesUtil.getClassType((PsiClass)targetBeanClass);
        }
        return null;
    }
}

