/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodInvokingFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        PsiClass psiClass;
        Module module;
        String methodName;
        SpringBean springBean;
        SpringPropertyDefinition targetMethod;
        if (context instanceof SpringBean && (targetMethod = SpringPropertyUtils.findPropertyByName((CommonSpringBean)(springBean = (SpringBean)context), (String)"targetMethod")) != null && StringUtil.isNotEmpty((String)(methodName = targetMethod.getValueAsString())) && (module = context.getModule()) != null && (psiClass = MethodInvokingFactoryBeanTypeResolver.getMethodInvokingPsiClass(null, module.getProject(), springBean)) != null) {
            PsiMethod[] methodsByName;
            for (PsiMethod method : methodsByName = psiClass.findMethodsByName(methodName, true)) {
                PsiType returnType = method.getReturnType();
                if (!(returnType instanceof PsiClassType)) continue;
                Set<String> set = Collections.singleton(returnType.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Nullable
    public static PsiClass getMethodInvokingPsiClass(@Nullable GlobalSearchScope scope, @NotNull Project project, @NotNull SpringBean springBean) {
        String className;
        SpringPropertyDefinition targetClassProperty;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver", "getMethodInvokingPsiClass"));
        }
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver", "getMethodInvokingPsiClass"));
        }
        SpringPropertyDefinition targetObjectProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"targetObject");
        if (targetObjectProperty != null) {
            PsiClass[] types;
            SpringBean bean;
            SpringBeanPointer springBeanPointer = targetObjectProperty.getRefValue();
            if (springBeanPointer != null) {
                PsiClass[] types2 = springBeanPointer.getEffectiveBeanType();
                if (types2.length == 1) {
                    return types2[0];
                }
            } else if (targetObjectProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = ((SpringProperty)targetObjectProperty).getBean())) && (types = BeanService.getInstance().getEffectiveBeanTypes((CommonSpringBean)bean)).length == 1) {
                return types[0];
            }
        }
        if ((targetClassProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"targetClass")) != null && (className = targetClassProperty.getValueAsString()) != null) {
            return JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver", "accept"));
        }
        return "org.springframework.beans.factory.config.MethodInvokingFactoryBean".equals(factoryClassName);
    }
}

