/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.NotNullFunction;
import com.intellij.util.xml.DomElement;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NavigationGutterIconBuilderUtil {
    public static final NotNullFunction<SpringBeanPointer, Collection<? extends PsiElement>> BEAN_POINTER_CONVERTOR = new NotNullFunction<SpringBeanPointer, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(SpringBeanPointer pointer) {
            if (!pointer.isValid()) {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$1", "fun"));
                }
                return set;
            }
            Set<PsiElement> set = Collections.singleton(pointer.getSpringBean().getIdentifyingPsiElement());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$1", "fun"));
            }
            return set;
        }
    };
    public static final NotNullFunction<CommonModelElement, Collection<? extends PsiElement>> COMMON_MODEL_ELEMENT_CONVERTOR = new NotNullFunction<CommonModelElement, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(CommonModelElement modelElement) {
            Set<PsiElement> set = Collections.singleton(modelElement.getIdentifyingPsiElement());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$2", "fun"));
            }
            return set;
        }
    };
    public static final NotNullFunction<SpringBeanPointer, Collection<? extends GotoRelatedItem>> BEAN_POINTER_GOTO_PROVIDER = new NotNullFunction<SpringBeanPointer, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(SpringBeanPointer dom) {
            CommonSpringBean bean = dom.getSpringBean();
            if (bean instanceof DomSpringBean) {
                List<DomGotoRelatedItem> list = Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)bean)));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$3", "fun"));
                }
                return list;
            }
            PsiElement element = bean.getIdentifyingPsiElement();
            if (element != null) {
                List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem(element));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$3", "fun"));
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$3", "fun"));
            }
            return list;
        }
    };
    public static final NotNullFunction<CommonModelElement, Collection<? extends GotoRelatedItem>> COMMON_MODEL_ELEMENT_GOTO_PROVIDER = new NotNullFunction<CommonModelElement, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(CommonModelElement dom) {
            if (dom instanceof DomSpringBean) {
                List<DomGotoRelatedItem> list = Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)dom)));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$4", "fun"));
                }
                return list;
            }
            PsiElement element = dom.getIdentifyingPsiElement();
            if (element != null) {
                List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem(element));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$4", "fun"));
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil$4", "fun"));
            }
            return list;
        }
    };

    private NavigationGutterIconBuilderUtil() {
    }

    public static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> holder, @NotNull PsiElement element) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, holder, element, SpringBundle.message("navigate.to.autowired.dependencies", new Object[0]));
    }

    public static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiElement element, @NotNull String tooltipText) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipText", "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil", "addAutowiredBeansGutterIcon"));
        }
        ArrayList<SpringBeanPointer> sorted = new ArrayList<SpringBeanPointer>(collection);
        Collections.sort(sorted, SpringBeanPointer.DISPLAY_COMPARATOR);
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ShowAutowiredDependencies, BEAN_POINTER_CONVERTOR, BEAN_POINTER_GOTO_PROVIDER).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(tooltipText).setTargets(sorted);
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(element));
    }
}

