/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.highlighting.SpringJavaAutowiringInspection;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringClassAnnotator
extends RelatedItemLineMarkerProvider {
    @Nullable
    protected PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/gutter/SpringClassAnnotator", "getElementToProcess"));
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    @NotNull
    protected static PsiElement getElementToAnnotate(@NotNull PsiElement psiElement) {
        PsiElement nameIdentifier;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/gutter/SpringClassAnnotator", "getElementToAnnotate"));
        }
        if (psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
            PsiElement psiElement2 = nameIdentifier;
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator", "getElementToAnnotate"));
            }
            return psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator", "getElementToAnnotate"));
        }
        return psiElement3;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringCommonUtils.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/gutter/SpringClassAnnotator", "collectNavigationMarkers"));
        }
        PsiElement element = this.getElementToProcess(psiElement);
        if (element instanceof PsiClass) {
            SpringClassAnnotator.annotateClass(psiElement, result, (PsiClass)element);
        } else if (element instanceof PsiMethod) {
            SpringClassAnnotator.annotateMethod((PsiMethod)element, result);
        } else if (element instanceof PsiField) {
            SpringClassAnnotator.annotateField(psiElement, result, (PsiField)element);
        } else if (psiElement instanceof PsiAnnotation) {
            SpringClassAnnotator.annotateComponentScan((PsiAnnotation)psiElement, result);
        }
    }

    private static void annotateClass(PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateClass"));
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            return;
        }
        if (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass)) {
            SpringClassAnnotator.addTestConfigurationGutter(result, psiClass);
            return;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (info.isMappedDomBean()) {
            SpringClassAnnotator.addSpringBeanGutterIcon(result, psiClass.getNameIdentifier(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    List domBeans = info.getMappedDomBeans();
                    Collections.sort(domBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                    List list = domBeans;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$1", "compute"));
                    }
                    return list;
                }
            });
        } else if (info.isStereotypeJavaBean()) {
            PsiElement elementToAnnotate = SpringClassAnnotator.getElementToAnnotate(psiElement);
            SpringClassAnnotator.addSpringJavaBeanGutterIcon(result, elementToAnnotate, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

                @NotNull
                protected Collection<? extends CommonModelElement> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    SmartList result = new SmartList();
                    List mappedBeans = info.getStereotypeMappedBeans();
                    for (JamSpringBeanPointer mappedBean : mappedBeans) {
                        if (!(mappedBean.getSpringBean() instanceof SpringJavaBean)) continue;
                        result.add(mappedBean.getSpringBean());
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                    Set configurationBeans = SpringJamUtils.getInstance().findStereotypeConfigurationBeans(SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass), mappedBeans, module);
                    result.addAll(configurationBeans);
                    SmartList smartList = result;
                    if (smartList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$2", "compute"));
                    }
                    return smartList;
                }
            });
        } else if (SpringCommonUtils.isSpringConfigured((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass))) {
            SpringClassAnnotator.annotatePsiClassSpringPropertyValues(result, psiClass, SpringModelUtils.getInstance().getSpringModel(psiElement).getConfigFiles());
        }
    }

    private static void annotateField(PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result, PsiField field) {
        CommonSpringModel processor;
        if (SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)field) && (processor = SpringAutowireUtil.getProcessingSpringModel(field.getContainingClass())) != null) {
            SpringClassAnnotator.processVariable((PsiModifierListOwner)field, result, processor, psiElement, field.getType());
        }
    }

    private static boolean isComponentScanAnno(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/gutter/SpringClassAnnotator", "isComponentScanAnno"));
        }
        if (!SpringClassAnnotator.isClassLevelAnnotation(psiAnnotation)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
        return psiClass != null && JamService.getJamService((Project)psiAnnotation.getProject()).getJamElement(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    private static boolean isClassLevelAnnotation(PsiAnnotation psiElement) {
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof PsiModifierList)) {
            return false;
        }
        return parent.getParent() instanceof PsiClass;
    }

    private static void annotateComponentScan(final @NotNull PsiAnnotation element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateComponentScan"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateComponentScan"));
        }
        if (!SpringClassAnnotator.isComponentScanAnno(element)) {
            return;
        }
        PsiClass owner = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (owner != null) {
            List scans = SpringJamUtils.getInstance().getComponentScans(owner);
            for (final SpringBeansPackagesScan scan : scans) {
                if (!(scan instanceof SpringComponentScan) || !element.equals(((SpringComponentScan)scan).getAnnotation())) continue;
                SpringClassAnnotator.addSpringJavaBeanGutterIcon(result, (PsiElement)element, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

                    @NotNull
                    protected Collection<? extends CommonModelElement> compute() {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                        if (module == null) {
                            Set set = Collections.emptySet();
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$3", "compute"));
                            }
                            return set;
                        }
                        Set scannedElements = scan.getScannedElements(module);
                        ArrayList beans = new ArrayList(BeanService.getInstance().mapSpringBeans((Collection)scannedElements));
                        Collections.sort(beans, SpringBeanPointer.DISPLAY_COMPARATOR);
                        List list = ContainerUtil.map(beans, (Function)SpringBeanPointer.TO_BEAN);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$3", "compute"));
                        }
                        return list;
                    }
                });
                return;
            }
        }
    }

    private static void addTestConfigurationGutter(Collection<? super RelatedItemLineMarkerInfo> result, PsiClass psiClass) {
        SpringContextHierarchy hierarchy;
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        ContextConfiguration contextConfiguration = (ContextConfiguration)service.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass);
        if (contextConfiguration != null) {
            SpringClassAnnotator.annotateContextConfiguration(result, contextConfiguration, psiClass);
        }
        if ((hierarchy = (SpringContextHierarchy)service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META})) != null) {
            for (SpringContextConfiguration configuration : hierarchy.getContextConfigurations()) {
                SpringClassAnnotator.annotateContextConfiguration(result, configuration, psiClass);
            }
        }
    }

    private static void annotateContextConfiguration(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull ContextConfiguration contextConfiguration, @NotNull PsiClass psiClass) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateContextConfiguration"));
        }
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateContextConfiguration"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateContextConfiguration"));
        }
        PsiAnnotation annotation = contextConfiguration.getAnnotation();
        if (annotation != null) {
            HashSet xmlContexts = new HashSet();
            HashSet javaContexts = new HashSet();
            SpringTestContextUtilImpl.discoverConfigFiles(contextConfiguration, (Set<XmlFile>)xmlContexts, (Set<PsiClass>)javaContexts, psiClass);
            HashSet toNavigate = new HashSet();
            toNavigate.addAll(xmlContexts);
            toNavigate.addAll(javaContexts);
            if (!toNavigate.isEmpty()) {
                NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Spring).setTargets((Collection)toNavigate).setPopupTitle(SpringBundle.message("spring.app.context.to.navigate", new Object[0])).setTooltipText(SpringBundle.message("spring.app.context.navigate.tooltip", new Object[0]));
                result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)annotation));
            }
        }
    }

    private static void annotatePsiClassSpringPropertyValues(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiClass psiClass, @NotNull Set<? extends PsiFile> xmlConfigFiles) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/gutter/SpringClassAnnotator", "annotatePsiClassSpringPropertyValues"));
        }
        if (xmlConfigFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlConfigFiles", "com/intellij/spring/gutter/SpringClassAnnotator", "annotatePsiClassSpringPropertyValues"));
        }
        if (DumbService.isDumb((Project)psiClass.getProject())) {
            return;
        }
        if (xmlConfigFiles.size() == 0) {
            return;
        }
        final List values = Collections.synchronizedList(new ArrayList());
        List springFiles = ContainerUtil.mapNotNull(xmlConfigFiles, (Function)new NullableFunction<PsiFile, VirtualFile>(){

            public VirtualFile fun(PsiFile psiFile) {
                return psiFile instanceof XmlFile ? psiFile.getVirtualFile() : null;
            }
        });
        ReferencesSearch.search((PsiElement)psiClass, (SearchScope)GlobalSearchScope.filesScope((Project)psiClass.getProject(), (Collection)springFiles)).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                SpringProperty value;
                DomElement domElement;
                PsiElement element = psiReference.getElement();
                if (element instanceof XmlElement && (domElement = DomUtil.getDomElement((PsiElement)element)) != null && !SpringClassAnnotator.isAnonymousBeanClass(domElement) && (value = (SpringProperty)domElement.getParentOfType(SpringProperty.class, false)) != null) {
                    values.add(value);
                }
                return true;
            }
        });
        if (!values.isEmpty()) {
            SpringClassAnnotator.addPropertiesGutterIcon(result, psiClass.getNameIdentifier(), new NotNullLazyValue<Collection<? extends DomElement>>(){

                @NotNull
                protected Collection<? extends DomElement> compute() {
                    List list = values;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$6", "compute"));
                    }
                    return list;
                }
            });
        }
    }

    private static boolean isAnonymousBeanClass(DomElement domElement) {
        XmlAttribute xmlAttribute;
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)domElement.getParentOfType(GenericAttributeValue.class, false);
        if (genericAttributeValue != null && (xmlAttribute = genericAttributeValue.getXmlAttribute()) != null && "class".equals(xmlAttribute.getName())) {
            return genericAttributeValue.getParent() instanceof SpringBean;
        }
        return false;
    }

    private static void annotateMethod(final PsiMethod method, Collection<? super RelatedItemLineMarkerInfo> result) {
        final PsiClass psiClass = method.getContainingClass();
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            Collection methodTypes;
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
            boolean autowired = false;
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
                if (info.isMappedProperty(method)) {
                    SpringClassAnnotator.addPropertiesGutterIcon(result, method.getNameIdentifier(), new NotNullLazyValue<Collection<? extends DomElement>>(){

                        @NotNull
                        protected Collection<? extends DomElement> compute() {
                            String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)method);
                            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                            Collection collection = info.getMappedProperties(propertyName);
                            if (collection == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$7", "compute"));
                            }
                            return collection;
                        }
                    });
                } else {
                    autowired = info.isAutowired();
                    if (autowired) {
                        SpringClassAnnotator.checkAutowiredMethod(method, result, info);
                    }
                }
            } else {
                List externalBeans;
                ContextJavaBean bean = SpringClassAnnotator.getStereotypeBean(method);
                if (bean != null) {
                    SpringClassAnnotator.addStereotypeBeanAutowiredCandidatesBeanGutterIcon(result, method, bean.getPsiAnnotation());
                }
                if (!(externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method)).isEmpty()) {
                    SpringClassAnnotator.addSpringBeanGutterIcon(result, method.getNameIdentifier(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            List externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method);
                            Collections.sort(externalBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                            List list = externalBeans;
                            if (list == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$8", "compute"));
                            }
                            return list;
                        }
                    });
                }
            }
            if (!autowired) {
                SpringClassAnnotator.processAnnotatedMethod(method, result);
            }
            if (!(methodTypes = info.getMethodTypes(method)).isEmpty()) {
                SpringClassAnnotator.addMethodTypesGutterIcon(result, method, methodTypes);
            }
        }
    }

    private static ContextJavaBean getStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/gutter/SpringClassAnnotator", "getStereotypeBean"));
        }
        return (ContextJavaBean)JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method);
    }

    public static boolean checkAutowiredMethod(PsiMethod method, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, SpringJavaClassInfo info) {
        CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass());
        if (model != null) {
            for (Autowire autowire : info.getAutowires()) {
                if (autowire == Autowire.BY_TYPE) {
                    PsiType type = PropertyUtil.getPropertyType((PsiMember)method);
                    if (type == null) continue;
                    return SpringClassAnnotator.processVariable((PsiModifierListOwner)method, result, model, (PsiElement)method.getNameIdentifier(), type);
                }
                if (autowire != Autowire.BY_NAME) continue;
                return SpringClassAnnotator.annotateByNameAutowiredMethod((PsiModifierListOwner)method, result, model, (PsiElement)method.getNameIdentifier());
            }
        }
        return false;
    }

    private static boolean annotateByNameAutowiredMethod(PsiModifierListOwner owner, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, PsiElement element) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/gutter/SpringClassAnnotator", "annotateByNameAutowiredMethod"));
        }
        Collection<SpringBeanPointer> collection = SpringClassAnnotator.getByNameAutowiredBean(owner, model);
        if (collection != null && !collection.isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, result, element, SpringBundle.message("navigate.to.by.name.autowired.dependencies", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static Collection<SpringBeanPointer> getByNameAutowiredBean(@NotNull PsiModifierListOwner owner, @NotNull CommonSpringModel model) {
        SpringBeanPointer bean;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/gutter/SpringClassAnnotator", "getByNameAutowiredBean"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/gutter/SpringClassAnnotator", "getByNameAutowiredBean"));
        }
        String name = null;
        if (owner instanceof PsiMethod) {
            name = PropertyUtil.getPropertyNameBySetter((PsiMethod)((PsiMethod)owner));
        } else if (owner instanceof PsiField) {
            name = ((PsiField)owner).getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)name)) != null) {
            return Collections.singleton(bean.getBasePointer());
        }
        return Collections.emptySet();
    }

    private static void processAnnotatedMethod(PsiMethod method, Collection<? super RelatedItemLineMarkerInfo> result) {
        CommonSpringModel model;
        if (SpringAutowireUtil.isInjectionPoint(method) && (model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass())) != null) {
            if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)method) != null && PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
                PsiParameter parameter = method.getParameterList().getParameters()[0];
                SpringClassAnnotator.processVariable((PsiModifierListOwner)method, result, model, (PsiElement)parameter, parameter.getType());
            } else {
                for (PsiParameter variable : method.getParameterList().getParameters()) {
                    SpringClassAnnotator.processVariable((PsiModifierListOwner)variable, result, model, (PsiElement)variable, variable.getType());
                }
            }
        }
    }

    private static boolean processVariable(PsiModifierListOwner variable, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, PsiElement element, @NotNull PsiType type) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/gutter/SpringClassAnnotator", "processVariable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/gutter/SpringClassAnnotator", "processVariable"));
        }
        Set<SpringBeanPointer> list = SpringJavaAutowiringInspection.checkAutowiredPsiMember(variable, type, null, model, false);
        if (list != null && !list.isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(list, result, element);
            }
            return true;
        }
        return false;
    }

    private static void addMethodTypesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiMethod psiMethod, Collection<Pair<DomElement, SpringJavaClassInfo.SpringMethodType>> targets) {
        String tooltipText = SpringBundle.message("spring.bean.methods.tooltip.navigate.declaration", new Object[0]);
        Icon icon = SpringApiIcons.SpringBeanMethod;
        if (targets.size() == 1) {
            SpringJavaClassInfo.SpringMethodType methodType = (SpringJavaClassInfo.SpringMethodType)targets.iterator().next().second;
            tooltipText = SpringBundle.message("spring.bean.method.tooltip.navigate.declaration", methodType.getName());
            if (methodType == SpringJavaClassInfo.SpringMethodType.FACTORY) {
                icon = SpringApiIcons.FactoryMethodBean;
            }
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)icon, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)NavigationGutterIconBuilder.DOM_GOTO_RELATED_ITEM_PROVIDER).setTargets((Collection)ContainerUtil.mapNotNull(targets, (Function)new Function<Pair<DomElement, SpringJavaClassInfo.SpringMethodType>, DomElement>(){

            public DomElement fun(Pair<DomElement, SpringJavaClassInfo.SpringMethodType> pair) {
                return (DomElement)pair.first;
            }
        })).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTooltipText(tooltipText);
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void addPropertiesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiIdentifier psiIdentifier, NotNullLazyValue<Collection<? extends DomElement>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringProperty, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)NavigationGutterIconBuilder.DOM_GOTO_RELATED_ITEM_PROVIDER).setTargets(targets).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.property.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.property.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiIdentifier));
    }

    private static void addSpringJavaBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends CommonModelElement>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringJavaBean, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_CONVERTOR, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_GOTO_PROVIDER).setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(psiIdentifier));
    }

    private static void addSpringBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiIdentifier psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringBean, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.BEAN_POINTER_GOTO_PROVIDER).setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiIdentifier));
    }

    private static void addStereotypeBeanAutowiredCandidatesBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull PsiMethod method, @NotNull PsiAnnotation annotation) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/gutter/SpringClassAnnotator", "addStereotypeBeanAutowiredCandidatesBeanGutterIcon"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/gutter/SpringClassAnnotator", "addStereotypeBeanAutowiredCandidatesBeanGutterIcon"));
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ShowAutowiredDependencies).setPopupTitle(SpringBundle.message("gutter.choose.autowired.candidates.title", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.autowired.candidates", new Object[0])).setTooltipText(SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                PsiType type = method.getReturnType();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
                Set<Object> set = type != null && module != null ? SpringAutowireUtil.getAutowiredMembers(type, module) : Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$10", "compute"));
                }
                return set;
            }
        });
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)annotation));
    }
}

