/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.google.gson.GsonBuilder;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.wrappers.SpringWFacet;
import com.intellij.spring.model.wrappers.WFileset;
import com.intellij.spring.model.wrappers.WModel;
import com.intellij.spring.model.wrappers.WModule;
import com.intellij.spring.model.wrappers.WProject;
import com.intellij.spring.model.wrappers.WSpringDependency;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DumpSpringConfigurationAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean hasSpring = project != null && SpringCommonUtils.hasSpringLibrary((Project)project) && ProjectFacetManager.getInstance((Project)project).hasFacets(SpringFacet.FACET_TYPE_ID);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Runnable process = new Runnable(){

            @Override
            public void run() {
                final String projectDumpJson = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DumpSpringConfigurationAction.getProjectDumpJson(project);
                    }
                });
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMultilineInputDialog((Project)project, (String)"", (String)"Spring Configuration Dump", (String)projectDumpJson, null, null);
                    }
                });
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "Gathering Spring Models", true, project);
    }

    @NotNull
    private static String getProjectDumpJson(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/actions/DumpSpringConfigurationAction", "getProjectDumpJson"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        SpringManager springManager = SpringManager.getInstance((Project)project);
        WProject dumpProject = new WProject();
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        int processedModules = 0;
        for (Module module : modules) {
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) continue;
            WModule dumpModule = new WModule(module.getName());
            dumpProject.modules.add(dumpModule);
            SpringWFacet dumpFacet = new SpringWFacet();
            dumpModule.facets.add(dumpFacet);
            Set fileSets = SpringFileSetService.getInstance().getAllSets(springFacet);
            for (SpringFileSet fileSet : fileSets) {
                pi.checkCanceled();
                WFileset dumpFileSet = new WFileset(fileSet);
                dumpFacet.filesets.add(dumpFileSet);
                List files = fileSet.getFiles();
                LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
                for (VirtualFilePointer file : files) {
                    PsiClass[] psiClasses;
                    VirtualFile virtualFile = file.getFile();
                    if (virtualFile == null) continue;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
                        LocalXmlModel model = springManager.getLocalSpringModel((XmlFile)psiFile);
                        if (model == null) continue;
                        DumpSpringConfigurationAction.visitRelated((LocalModel)model, visited, dumpFileSet);
                        continue;
                    }
                    if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiFile)) continue;
                    PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                    for (PsiClass psiClass : psiClasses = javaFile.getClasses()) {
                        LocalAnnotationModel model = springManager.getLocalSpringModel(psiClass);
                        if (model == null) continue;
                        DumpSpringConfigurationAction.visitRelated((LocalModel)model, visited, dumpFileSet);
                    }
                }
            }
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        pi.setText("Generating JSON...");
        String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)dumpProject);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/DumpSpringConfigurationAction", "getProjectDumpJson"));
        }
        return string;
    }

    private static void visitRelated(@NotNull LocalModel model, @NotNull Set<LocalModel> visited, @NotNull WFileset dumpFileSet) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/actions/DumpSpringConfigurationAction", "visitRelated"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/spring/model/actions/DumpSpringConfigurationAction", "visitRelated"));
        }
        if (dumpFileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dumpFileSet", "com/intellij/spring/model/actions/DumpSpringConfigurationAction", "visitRelated"));
        }
        WModel dumpModel = new WModel(model);
        dumpFileSet.models.add(dumpModel);
        visited.add(model);
        Set dependentModels = model.getDependentLocalModels();
        for (Pair dependentModel : dependentModels) {
            WSpringDependency dependency = new WSpringDependency((Pair<LocalModel, LocalModelDependency>)dependentModel);
            dumpModel.dependencies.add(dependency);
            if (visited.contains(dependentModel.first)) continue;
            DumpSpringConfigurationAction.visitRelated((LocalModel)dependentModel.first, visited, dumpFileSet);
        }
    }
}

