/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.aliasFor;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringAliasFor
implements JamElement {
    public static final SemKey<SpringAliasFor> SEM_KEY = SemKey.createKey((String)"SpringAliasFor", (SemKey[])new SemKey[0]);
    public static final JamMethodMeta<SpringAliasFor> METHOD_META = new JamMethodMeta(null, SpringAliasFor.class, SEM_KEY);
    private static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.core.annotation.AliasFor");
    private static final JamClassAttributeMeta.Single ALIAS_FOR_CLASS_ATTR_META = JamAttributeMeta.singleClass((String)"annotation");
    private static final JamStringAttributeMeta.Single<PsiMethod> ALIAS_FOR_ATTR_META = JamAttributeMeta.singleString((String)"attribute", (JamConverter)new AliasForAttributePsiMethodJamConverter());
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final PsiMethod myPsiMethod;

    public SpringAliasFor(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/model/aliasFor/SpringAliasFor", "<init>"));
        }
        this.myPsiMethod = psiMethod;
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiMethod);
    }

    public SpringAliasFor(PsiAnnotation annotation) {
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
        this.myPsiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class, (boolean)true);
    }

    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = this.myPsiMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasFor", "getPsiElement"));
        }
        return psiMethod;
    }

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @NotNull
    public static JamClassAttributeElement getAliasForAnnotationClassElement(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/aliasFor/SpringAliasFor", "getAliasForAnnotationClassElement"));
        }
        JamClassAttributeElement jamClassAttributeElement = (JamClassAttributeElement)ANNO_META.getAttribute((PsiModifierListOwner)method, (JamAttributeMeta)ALIAS_FOR_CLASS_ATTR_META);
        if (jamClassAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasFor", "getAliasForAnnotationClassElement"));
        }
        return jamClassAttributeElement;
    }

    @Nullable
    public static PsiClass getAliasForAnnotationClass(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/aliasFor/SpringAliasFor", "getAliasForAnnotationClass"));
        }
        PsiClass aClass = SpringAliasFor.getAliasForAnnotationClassElement(method).getValue();
        return aClass == null ? method.getContainingClass() : aClass;
    }

    @Nullable
    public PsiClass getAnnotationClass() {
        return SpringAliasFor.getAliasForAnnotationClass(this.getPsiElement());
    }

    public String getAttributeName() {
        return ALIAS_FOR_ATTR_META.getJam(this.myPsiAnnotation).getStringValue();
    }

    @Nullable
    public PsiAnnotation getAnnotation() {
        return ANNO_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    static {
        METHOD_META.addAnnotation(ANNO_META);
        ANNO_META.addAttribute((JamAttributeMeta)ALIAS_FOR_CLASS_ATTR_META);
        ANNO_META.addAttribute(ALIAS_FOR_ATTR_META);
    }

    private static class AliasForAttributePsiMethodJamConverter
    extends JamSimpleReferenceConverter<PsiMethod> {
        private AliasForAttributePsiMethodJamConverter() {
        }

        public PsiMethod fromString(@Nullable String s, JamStringAttributeElement<PsiMethod> context) {
            for (PsiMethod psiMethod : AliasForAttributePsiMethodJamConverter.getAliasForMethods(context)) {
                if (!psiMethod.getName().equals(s)) continue;
                return psiMethod;
            }
            return null;
        }

        private static PsiMethod[] getAliasForMethods(@NotNull JamStringAttributeElement<PsiMethod> context) {
            PsiClass aliasForAnnotationClass;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasFor$AliasForAttributePsiMethodJamConverter", "getAliasForMethods"));
            }
            PsiMethod psiMethod = AliasForAttributePsiMethodJamConverter.getIdentifyingMethod(context);
            if (psiMethod != null && (aliasForAnnotationClass = SpringAliasFor.getAliasForAnnotationClass(psiMethod)) != null) {
                return aliasForAnnotationClass.getAllMethods();
            }
            return PsiMethod.EMPTY_ARRAY;
        }

        private static PsiMethod getIdentifyingMethod(@NotNull JamStringAttributeElement<PsiMethod> context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasFor$AliasForAttributePsiMethodJamConverter", "getIdentifyingMethod"));
            }
            PsiAnnotationMemberValue contextPsiElement = context.getPsiElement();
            if (contextPsiElement != null) {
                return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)contextPsiElement, PsiMethod.class);
            }
            return null;
        }

        public Collection<PsiMethod> getVariants(JamStringAttributeElement<PsiMethod> context) {
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            PsiMethod identifyingMethod = AliasForAttributePsiMethodJamConverter.getIdentifyingMethod(context);
            if (identifyingMethod != null) {
                PsiType returnType = identifyingMethod.getReturnType();
                for (PsiMethod method : AliasForAttributePsiMethodJamConverter.getAliasForMethods(context)) {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || !containingClass.isAnnotationType()) continue;
                    PsiType methodReturnType = method.getReturnType();
                    if (returnType != null && methodReturnType != null && !returnType.isAssignableFrom(methodReturnType)) continue;
                    methods.add(method);
                }
            }
            return methods;
        }
    }
}

