/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.aliasFor;

import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAliasForUtils {
    @NotNull
    public static List<SpringAliasFor> getAliasForAttributes(@Nullable PsiClass psiClass) {
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<SpringAliasFor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
            }
            return list;
        }
        List list = JamService.getJamService((Project)psiClass.getProject()).getAnnotatedMembersList(psiClass, SpringAliasFor.SEM_KEY, false, true, false, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
        }
        return list;
    }

    @Nullable
    public static SpringAliasFor findAliasFor(@NotNull Project project, @Nullable String toSearchInAnnotation, @NotNull String aliasedClassName, @NotNull String attrName) {
        PsiClass annotationClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (aliasedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasedClassName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (toSearchInAnnotation == null) {
            return null;
        }
        PsiClass toSearchInClass = JavaPsiFacade.getInstance((Project)project).findClass(toSearchInAnnotation, GlobalSearchScope.allScope((Project)project));
        if (toSearchInClass != null && toSearchInClass.isAnnotationType() && (annotationClass = JavaPsiFacade.getInstance((Project)project).findClass(aliasedClassName, GlobalSearchScope.allScope((Project)project))) != null && annotationClass.isAnnotationType()) {
            for (SpringAliasFor aliasFor : SpringAliasForUtils.getAliasForAttributes(toSearchInClass)) {
                if (!attrName.equals(aliasFor.getAttributeName()) || !annotationClass.equals(aliasFor.getAnnotationClass())) continue;
                return aliasFor;
            }
        }
        return null;
    }
}

