/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.facet.Facet;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringContextIcons;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import icons.SpringApiIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UseExistingBeanFromOtherContextQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private final String myBeanId;
    private final PsiFile myBeanFile;
    private final SpringFileSet mySpringFileSet;
    private final String myFilesetName;
    private static int quickFixActionIndexToInvokeInTest = -1;

    UseExistingBeanFromOtherContextQuickFix(String beanId, PsiFile beanFile, SpringFileSet springFileSet) {
        this.myBeanId = beanId;
        this.myBeanFile = beanFile;
        this.mySpringFileSet = springFileSet;
        this.myFilesetName = springFileSet.getName();
    }

    public static void setQuickFixActionIndexToInvokeInTest(int actionIdx) {
        quickFixActionIndexToInvokeInTest = actionIdx;
    }

    @NotNull
    public String getName() {
        String string = "Use existing bean from context '" + this.myFilesetName + "'...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Use existing bean" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "getFamilyName"));
        }
        return "Use existing bean";
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "applyFix"));
        }
        final PsiElement element = descriptor.getPsiElement();
        final PsiFile file = element.getContainingFile();
        final SpringFileSet currentFileSet = UseExistingBeanFromOtherContextQuickFix.getCurrentFileSet(project, file);
        AnAction addDependencyToFileSetAction = new AnAction("Add dependency to context '" + this.myFilesetName + "'", null, SpringContextIcons.ParentContext){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(currentFileSet.getDependencyFileSets().isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                currentFileSet.addDependency(UseExistingBeanFromOtherContextQuickFix.this.mySpringFileSet);
                UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
            }
        };
        AnAction addSpringXmlToOurFileSetAction = new AnAction("Add '" + this.myBeanFile.getName() + "' to context '" + currentFileSet.getName() + "'", null, SpringApiIcons.FileSet){

            public void actionPerformed(AnActionEvent e) {
                VirtualFile virtualFile = UseExistingBeanFromOtherContextQuickFix.this.myBeanFile.getVirtualFile();
                assert (virtualFile != null);
                currentFileSet.addFile(virtualFile);
                UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
            }
        };
        final String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myBeanFile.getVirtualFile(), (VirtualFile)file.getContainingDirectory().getVirtualFile(), (char)'/');
        AnAction addImportAction = new AnAction("Add <import> for '" + this.myBeanFile.getName() + "'", null, AllIcons.Nodes.Tag){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(relativePath != null && UseExistingBeanFromOtherContextQuickFix.this.myBeanFile instanceof XmlFile);
            }

            public void actionPerformed(AnActionEvent e) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                LocalXmlModel model = SpringManager.getInstance((Project)project).getLocalSpringModel((XmlFile)file);
                assert (model != null);
                DomFileElement root = model.getRoot();
                assert (root != null);
                final Beans beans = (Beans)root.getRootElement();
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        SpringImport springImport = beans.addImport();
                        GenericAttributeValue resource = springImport.getResource();
                        resource.setStringValue(relativePath);
                        UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
                    }
                });
            }
        };
        AnAction openSpringFacetSettings = new AnAction("Open Spring facet settings...", null, SpringApiIcons.Spring){

            public void actionPerformed(AnActionEvent e) {
                ModulesConfigurator.showFacetSettingsDialog((Facet)UseExistingBeanFromOtherContextQuickFix.getSpringFacet(file), null);
            }
        };
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{addDependencyToFileSetAction, addSpringXmlToOurFileSetAction, addImportAction, openSpringFacetSettings});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (quickFixActionIndexToInvokeInTest != -1);
            actionGroup.getChildren(null)[quickFixActionIndexToInvokeInTest].actionPerformed(null);
            return;
        }
        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>((ActionGroup)actionGroup){
            final /* synthetic */ ActionGroup val$actionGroup;
            {
                this.val$actionGroup = actionGroup;
            }

            public void consume(DataContext dataContext) {
                JBPopupFactory.getInstance().createActionGroupPopup("Choose Fix For '" + UseExistingBeanFromOtherContextQuickFix.this.myBeanId + "'", this.val$actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true).showInBestPositionFor(dataContext);
            }
        });
    }

    private static void rehighlight(final PsiFile psiFile) {
        SpringFacet springFacet = UseExistingBeanFromOtherContextQuickFix.getSpringFacet(psiFile);
        SpringFacetConfiguration configuration = (SpringFacetConfiguration)springFacet.getConfiguration();
        configuration.setModified();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DomElementAnnotationsManager.getInstance((Project)psiFile.getProject()).dropAnnotationsCache();
                DaemonCodeAnalyzer.getInstance((Project)psiFile.getProject()).restart();
            }
        });
    }

    @NotNull
    private static SpringFacet getSpringFacet(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        assert (module != null);
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        assert (springFacet != null);
        SpringFacet springFacet2 = springFacet;
        if (springFacet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "getSpringFacet"));
        }
        return springFacet2;
    }

    @NotNull
    private static SpringFileSet getCurrentFileSet(Project project, PsiFile file) {
        Set models = SpringManager.getInstance((Project)project).getSpringModelsByFile(file);
        for (SpringModel model : models) {
            SpringFileSet currentFileSet = model.getFileSet();
            if (currentFileSet == null) continue;
            SpringFileSet springFileSet = currentFileSet;
            if (springFileSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix", "getCurrentFileSet"));
            }
            return springFileSet;
        }
        throw new IllegalStateException("no fileset for " + file);
    }
}

