/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.annotator;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventModelUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringEventListenerAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>> PUBLISH_EVENT_CONVERTOR = new NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PublishEventPointDescriptor o) {
            List list = ContainerUtil.createMaybeSingletonList((Object)o.getNavigatableElement());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator$1", "fun"));
            }
            return list;
        }
    };
    private static final NotNullFunction<SpringEventListener, Collection<? extends PsiElement>> EVENT_LISTENER_CONVERTOR = new NotNullFunction<SpringEventListener, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(SpringEventListener o) {
            List list = ContainerUtil.createMaybeSingletonList((Object)o.getPsiElement());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator$2", "fun"));
            }
            return list;
        }
    };

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringCommonUtils.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "collectNavigationMarkers"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module != null) {
            if (psiElement instanceof PsiMethod) {
                PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiElement), (String[])new String[]{"org.springframework.context.event.EventListener"});
                if (psiAnnotation != null) {
                    PsiType returnType;
                    Collection<PublishEventPointDescriptor> points;
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    PsiType handledType = SpringEventModelUtils.getEventListenerHandledType(psiMethod);
                    if (handledType != null && (points = SpringEventModelUtils.getPublishPoints(module, handledType)).size() > 0) {
                        SpringEventListenerAnnotator.annotateEventListenerMethod(points, psiAnnotation, result);
                    }
                    if ((returnType = psiMethod.getReturnType()) != null && !PsiType.VOID.equals((Object)returnType)) {
                        SpringEventListenerAnnotator.annotatePublishPoints(module, result, returnType, (PsiElement)psiMethod.getReturnTypeElement());
                    }
                }
            } else if (psiElement instanceof PsiMethodCallExpression && SpringEventModelUtils.isPublishEventExpression((PsiMethodCallExpression)psiElement)) {
                SpringEventListenerAnnotator.annotateMethodCallExpression((PsiMethodCallExpression)psiElement, module, result);
            }
        }
    }

    private static void annotateEventListenerMethod(@NotNull Collection<PublishEventPointDescriptor> points, @NotNull PsiAnnotation psiAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (points == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Publisher, PUBLISH_EVENT_CONVERTOR).setTargets(points).setPopupTitle(SpringBundle.message("spring.event.publisher.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiAnnotation));
    }

    private static void annotateMethodCallExpression(@NotNull PsiMethodCallExpression expression, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiType publishedType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        if (expressions.length == 1 && (publishedType = expressions[0].getType()) != null) {
            SpringEventListenerAnnotator.annotatePublishPoints(module, result, publishedType, (PsiElement)expression.getMethodExpression());
        }
    }

    private static void annotatePublishPoints(@NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiType publishedType, @NotNull PsiElement element) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (publishedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishedType", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        List<SpringEventListener> listeners = SpringEventModelUtils.getEventListeners(module, publishedType);
        if (listeners.size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Listener, EVENT_LISTENER_CONVERTOR).setTargets(listeners).setPopupTitle(SpringBundle.message("spring.event.listener.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.listener.tooltip.text", new Object[0]));
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(element));
        }
    }
}

