/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.highlighting.SpringJavaAutowiringInspection;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutowireUtil {
    private static final Set<String> AUTOWIRED_ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "javax.annotation.Resource"});
    @NonNls
    private static final Set<String> STANDARD_AUTOWIRED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpSession", "org.springframework.web.context.WebApplicationContext", "org.springframework.beans.factory.BeanFactory", "org.springframework.context.ApplicationContext", "org.springframework.context.ApplicationEventPublisher", "org.springframework.context.MessageSource", "org.springframework.core.io.ResourceLoader", "org.springframework.core.env.Environment"});

    private SpringAutowireUtil() {
    }

    public static Map<PsiMethod, Collection<SpringBeanPointer>> getByTypeAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = springBean.getBeanClass();
        if (beanClass != null && model != null && SpringAutowireUtil.isByTypeAutowired(springBean)) {
            for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                PsiParameter parameter;
                Set<SpringBeanPointer> list;
                if (!SpringAutowireUtil.isPropertyAutowired(psiMethod, springBean) || (list = SpringAutowireUtil.autowireByType(model, (parameter = psiMethod.getParameterList().getParameters()[0]).getType(), parameter.getName())).size() <= 0) continue;
                autowiredMap.put(psiMethod, list);
            }
        }
        return autowiredMap;
    }

    @NotNull
    public static Set<SpringBeanPointer> excludeAutowireCandidates(@NotNull List<SpringBeanPointer> beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeAutowireCandidates"));
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.excludeAutowireCandidates(beans, null, model);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeAutowireCandidates"));
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> excludeAutowireCandidates(@NotNull List<SpringBeanPointer> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeAutowireCandidates"));
        }
        HashSet<SpringBeanPointer> pointers = new HashSet<SpringBeanPointer>();
        List<SpringBeanPointer> primaryBeans = SpringAutowireUtil.getPrimaryBeans(beans, primaryCandidateName, model);
        if (!primaryBeans.isEmpty()) {
            for (SpringBeanPointer primaryBean : primaryBeans) {
                if (!SpringAutowireUtil.isAutowireCandidate(primaryBean)) continue;
                pointers.add(primaryBean);
            }
            HashSet<SpringBeanPointer> hashSet = pointers;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeAutowireCandidates"));
            }
            return hashSet;
        }
        for (SpringBeanPointer beanPointer : beans) {
            if (!SpringAutowireUtil.isAutowireCandidate(beanPointer)) continue;
            pointers.add(beanPointer);
        }
        HashSet<SpringBeanPointer> hashSet = pointers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeAutowireCandidates"));
        }
        return hashSet;
    }

    @NotNull
    private static List<SpringBeanPointer> getPrimaryBeans(@NotNull List<SpringBeanPointer> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getPrimaryBeans"));
        }
        if (primaryCandidateName == null) {
            List<SpringBeanPointer> list = SpringAutowireUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getPrimaryBeans"));
            }
            return list;
        }
        SmartList byPrimary = new SmartList();
        SmartList byName = new SmartList();
        for (SpringBeanPointer springBeanPointer : beans) {
            if (!springBeanPointer.isValid()) continue;
            CommonSpringBean springBean = springBeanPointer.getSpringBean();
            if (springBean.isPrimary()) {
                if (SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) {
                    List<SpringBeanPointer> list = Collections.singletonList(springBeanPointer);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getPrimaryBeans"));
                    }
                    return list;
                }
                byPrimary.add(springBeanPointer);
                continue;
            }
            if (!SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) continue;
            byName.add(springBeanPointer);
        }
        SmartList smartList = byPrimary.isEmpty() ? byName : byPrimary;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getPrimaryBeans"));
        }
        return smartList;
    }

    private static boolean isMyName(@Nullable String name, @NotNull SpringBeanPointer springBeanPointer, @Nullable CommonSpringModel model) {
        if (springBeanPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBeanPointer", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isMyName"));
        }
        if (name == null) {
            return false;
        }
        String beanName = springBeanPointer.getName();
        if (name.equals(beanName)) {
            return true;
        }
        if (beanName != null && model != null) {
            for (String aliasName : model.getAllBeanNames(beanName)) {
                if (!name.equals(aliasName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAutowireCandidate(@Nullable SpringBeanPointer pointer) {
        if (pointer == null || !pointer.isValid()) {
            return false;
        }
        CommonSpringBean springBean = pointer.getSpringBean();
        if (!(springBean instanceof SpringBean)) {
            return true;
        }
        if (((SpringBean)springBean).isAbstract()) {
            return false;
        }
        DefaultableBoolean autoWireCandidate = (DefaultableBoolean)((SpringBean)springBean).getAutowireCandidate().getValue();
        return (autoWireCandidate == null || autoWireCandidate.getBooleanValue() != false) && SpringAutowireUtil.isDefaultAutowireCandidate(springBean);
    }

    private static boolean isDefaultAutowireCandidate(CommonSpringBean springBean) {
        String autowireCandidates;
        Beans beans;
        if (springBean instanceof SpringBean && (beans = (Beans)((SpringBean)springBean).getParentOfType(Beans.class, false)) != null && StringUtil.isNotEmpty((String)(autowireCandidates = (String)beans.getDefaultAutowireCandidates().getValue()))) {
            String beanName = springBean.getBeanName();
            String[] aliases = springBean.getAliases();
            for (String patternText : StringUtil.split((String)autowireCandidates, (String)",")) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)patternText.trim()));
                if (SpringAutowireUtil.isMatched(pattern, beanName)) {
                    return true;
                }
                for (String alias : aliases) {
                    if (!SpringAutowireUtil.isMatched(pattern, alias)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean isMatched(Pattern pattern, @Nullable String beanName) {
        return beanName != null && pattern.matcher(beanName).matches();
    }

    public static Map<PsiType, Collection<SpringBeanPointer>> getConstructorAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = springBean.getBeanClass();
        if (beanClass != null && SpringAutowireUtil.isConstructorAutowire(springBean)) {
            PsiMethod checkedMethod;
            boolean instantiatedByFactory = SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean);
            PsiMethod psiMethod = checkedMethod = instantiatedByFactory ? (PsiMethod)springBean.getFactoryMethod().getValue() : SpringConstructorArgResolveUtil.getSpringBeanConstructor(springBean, model);
            if (checkedMethod != null) {
                List list = springBean.getConstructorArgs();
                Map<Integer, ConstructorArg> indexedArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(list);
                PsiParameter[] parameters = checkedMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    PsiType psiType;
                    Set<SpringBeanPointer> springBeans;
                    PsiParameter parameter = parameters[i];
                    if (SpringConstructorArgResolveUtil.acceptParameter(parameter, list, indexedArgs, i) || (springBeans = SpringAutowireUtil.autowireByType(model, psiType = parameter.getType())).isEmpty()) continue;
                    autowiredMap.put(psiType, springBeans);
                }
            }
        }
        return autowiredMap;
    }

    public static boolean isPropertyDefined(SpringBean springBean, String propertyName) {
        return springBean.getProperty(propertyName) != null;
    }

    public static Map<PsiMethod, SpringBeanPointer> getByNameAutowiredProperties(SpringBean springBean) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = springBean.getBeanClass();
        if (beanClass != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModelByBean((CommonSpringBean)springBean);
            if (SpringAutowireUtil.isByNameAutowired(springBean)) {
                for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                    if (!PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) continue;
                    PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                    Set<SpringBeanPointer> list = SpringAutowireUtil.autowireByType(model, parameter.getType());
                    String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod);
                    for (SpringBeanPointer pointer : list) {
                        if (!pointer.isValid() || !SpringBeanUtils.getInstance().findBeanNames(pointer.getSpringBean()).contains(propertyName) || SpringAutowireUtil.isPropertyDefined(springBean, propertyName)) continue;
                        autowiredMap.put(psiMethod, pointer);
                    }
                }
            }
        }
        return autowiredMap;
    }

    private static boolean isPropertyAutowired(PsiMethod psiMethod, SpringBean springBean) {
        PsiParameter parameter;
        PsiType psiType;
        if (PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod) && (psiType = (parameter = psiMethod.getParameterList().getParameters()[0]).getType()) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass != null && !SpringAutowireUtil.isPropertyDefined(springBean, PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod));
        }
        return false;
    }

    public static boolean isByTypeAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_TYPE);
    }

    public static boolean isByNameAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_NAME);
    }

    public static boolean isConstructorAutowire(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.CONSTRUCTOR);
    }

    public static Map<PsiMember, Set<SpringBeanPointer>> getAutowireAnnotationProperties(CommonSpringBean springBean, @NotNull CommonSpringModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAutowireAnnotationProperties"));
        }
        HashMap map = new HashMap();
        PsiClass beanClass = springBean.getBeanClass();
        if (beanClass != null) {
            for (PsiMethod psiMethod : SpringAutowireUtil.getAnnotatedAutowiredMethods(beanClass)) {
                for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                    PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)parameter);
                    if (psiAnnotation != null) {
                        SpringAutowireUtil.addAutowiredBeans((Map<PsiMember, Set<SpringBeanPointer>>)map, (PsiMember)psiMethod, SpringAutowireUtil.getQualifiedBeans(psiAnnotation, model), model);
                        continue;
                    }
                    SpringAutowireUtil.addAutowiredBeans((Map<PsiMember, Set<SpringBeanPointer>>)map, (PsiMember)psiMethod, SpringBeanCoreUtils.getBeansByType(parameter.getType(), model), model);
                }
            }
            for (PsiField psiField : SpringAutowireUtil.getAnnotatedAutowiredFields(beanClass)) {
                PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiField);
                if (psiAnnotation != null) {
                    SpringAutowireUtil.addAutowiredBeans((Map<PsiMember, Set<SpringBeanPointer>>)map, (PsiMember)psiField, SpringAutowireUtil.getQualifiedBeans(psiAnnotation, model), model);
                    continue;
                }
                Set<SpringBeanPointer> beans = SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)psiField, psiField.getType(), null, model, false);
                if (beans == null) continue;
                SpringAutowireUtil.addAutowiredBeans((Map<PsiMember, Set<SpringBeanPointer>>)map, (PsiMember)psiField, new ArrayList<SpringBeanPointer>(beans), model);
            }
        }
        return map;
    }

    private static void addAutowiredBeans(@NotNull Map<PsiMember, Set<SpringBeanPointer>> map, @NotNull PsiMember psiMember, @NotNull List<SpringBeanPointer> beans, CommonSpringModel model) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredBeans"));
        }
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredBeans"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredBeans"));
        }
        Set<SpringBeanPointer> list = SpringAutowireUtil.excludeAutowireCandidates(beans, null, model);
        if (!list.isEmpty()) {
            if (!map.containsKey(psiMember)) {
                map.put(psiMember, list);
            } else {
                map.get(psiMember).addAll(list);
            }
        }
    }

    @NotNull
    public static List<SpringBeanPointer> getQualifiedBeans(@NotNull PsiAnnotation psiAnnotation, @Nullable CommonSpringModel model) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getQualifiedBeans"));
        }
        if (model == null) {
            List<SpringBeanPointer> list = SpringAutowireUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getQualifiedBeans"));
            }
            return list;
        }
        SpringJamQualifier qualifier = new SpringJamQualifier(psiAnnotation, null);
        List list = model.findQualifiedBeans((SpringQualifier)qualifier);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getQualifiedBeans"));
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation getQualifiedAnnotation(PsiModifierListOwner modifierListOwner) {
        return SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
    }

    @Nullable
    private static PsiAnnotation getQualifiedAnnotation(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        PsiMethod psiMethod;
        if (module == null) {
            return null;
        }
        JamAnnotationTypeUtil jamAnnotationTypeUtil = JamAnnotationTypeUtil.getInstance((Module)module);
        List annotationTypeClasses = jamAnnotationTypeUtil.getQualifierAnnotationTypesWithChildren();
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)annotationTypeClass, (String)Target.class.getName(), (boolean)false) && (!JamCommonUtil.isAcceptedFor((PsiClass)annotationTypeClass, (ElementType[])new ElementType[]{ElementType.FIELD}) || !(modifierListOwner instanceof PsiField)) && (!JamCommonUtil.isAcceptedFor((PsiClass)annotationTypeClass, (ElementType[])new ElementType[]{ElementType.PARAMETER}) || !(modifierListOwner instanceof PsiParameter)) || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
            return annotation;
        }
        if (modifierListOwner instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)modifierListOwner, PsiMethod.class)) != null) {
            for (PsiClass annotationTypeClass : annotationTypeClasses) {
                PsiAnnotation annotation;
                if (!JamCommonUtil.isAcceptedFor((PsiClass)annotationTypeClass, (ElementType[])new ElementType[]{ElementType.METHOD}) || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAutowiredAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAutowiredAnnotation"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            for (String annotation : AUTOWIRED_ANNOTATIONS) {
                PsiAnnotation autowireAnnotation = modifierList.findAnnotation(annotation);
                if (autowireAnnotation == null) continue;
                return autowireAnnotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getResourceAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getResourceAnnotation"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return modifierList.findAnnotation("javax.annotation.Resource");
        }
        return null;
    }

    public static boolean isAutowiredByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isAutowiredByAnnotation"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("static") || modifierList.getAnnotations().length == 0) {
            return false;
        }
        Set<String> autowireAnnotations = SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner));
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, autowireAnnotations);
    }

    public static boolean isInjectionPoint(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isInjectionPoint"));
        }
        return SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod) || SpringAutowireUtil.isStereotypeBean(psiMethod);
    }

    private static boolean isStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isStereotypeBean"));
        }
        return JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method) != null;
    }

    public static boolean isRequired(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isRequired"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation required = modifierList.findAnnotation("org.springframework.beans.factory.annotation.Required");
            if (required != null) {
                return true;
            }
            PsiAnnotation autowiredAnnotation = SpringAutowireUtil.getAutowiredAnnotation(owner);
            if (autowiredAnnotation != null) {
                Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)autowiredAnnotation.findAttributeValue("required"), Boolean.class);
                return value == null || value != false;
            }
        }
        return true;
    }

    @NotNull
    public static List<PsiMethod> getAnnotatedAutowiredMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAnnotatedAutowiredMethods"));
        }
        SmartList methods = new SmartList();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) continue;
            methods.add(psiMethod);
        }
        SmartList smartList = methods;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAnnotatedAutowiredMethods"));
        }
        return smartList;
    }

    @NotNull
    public static List<PsiField> getAnnotatedAutowiredFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAnnotatedAutowiredFields"));
        }
        SmartList fields = new SmartList();
        for (PsiField psiField : psiClass.getAllFields()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField)) continue;
            fields.add(psiField);
        }
        SmartList smartList = fields;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAnnotatedAutowiredFields"));
        }
        return smartList;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.autowireByType(model, psiType, null);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        Set<SpringBeanPointer> set = SpringAutowireUtil.autowireByType(model, psiType, primaryCandidateName, true);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName, boolean filterByGenerics) {
        PsiClass psiClass;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        PsiType beanType = SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType);
        if (beanType instanceof PsiClassType && (psiClass = ((PsiClassType)beanType).resolve()) != null) {
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors().effectiveBeanTypes();
            List beans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
            Set<SpringBeanPointer> pointers = SpringAutowireUtil.excludeAutowireCandidates(beans, primaryCandidateName, model);
            Set<SpringBeanPointer> filtered = SpringAutowireUtil.excludeOverridenDefaultBeans(pointers);
            Set<SpringBeanPointer> set = filterByGenerics ? SpringAutowireUtil.filterByGenerics(filtered, beanType) : filtered;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
            }
            return set;
        }
        Set<SpringBeanPointer> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "autowireByType"));
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterByGenerics(@NotNull Set<SpringBeanPointer> pointers, @NotNull PsiType type) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterByGenerics"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterByGenerics"));
        }
        HashSet filtered = ContainerUtil.newHashSet();
        block0: for (SpringBeanPointer pointer : pointers) {
            if (SpringAutowireUtil.isAssignable(type, pointer.getBeanClass())) {
                filtered.add(pointer);
                continue;
            }
            for (PsiClass beanClass : pointer.getEffectiveBeanType()) {
                if (!SpringAutowireUtil.isAssignable(type, beanClass)) continue;
                filtered.add(pointer);
                continue block0;
            }
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterByGenerics"));
        }
        return hashSet;
    }

    private static boolean isAssignable(@NotNull PsiType type, @Nullable PsiClass beanClass) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isAssignable"));
        }
        if (beanClass == null) {
            return false;
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory().createType(beanClass);
        return type.isAssignableFrom((PsiType)psiClassType);
    }

    public static PsiType getAutowiredEffectiveBeanTypes(@NotNull PsiType psiType) {
        PsiClassType injectProviderType;
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAutowiredEffectiveBeanTypes"));
        }
        if (psiType instanceof PsiArrayType) {
            return SpringAutowireUtil.getAutowiredEffectiveBeanTypes(((PsiArrayType)psiType).getComponentType());
        }
        PsiType beanType = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
        if (beanType != null) {
            return beanType;
        }
        if (psiType instanceof PsiClassType && SpringAutowireUtil.isInjectProvider((PsiClassType)psiType) && (injectProviderType = SpringAutowireUtil.getInjectProviderType((PsiClassType)psiType)) != null) {
            return injectProviderType;
        }
        return psiType;
    }

    public static boolean isInjectProvider(@NotNull PsiClassType aType) {
        if (aType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aType", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isInjectProvider"));
        }
        return InheritanceUtil.isInheritor((PsiClass)aType.resolve(), (String)"javax.inject.Provider");
    }

    @Nullable
    public static PsiClassType getInjectProviderType(@NotNull PsiClassType classType) {
        PsiType type;
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getInjectProviderType"));
        }
        List psiTypes = SpringCommonUtils.resolveGenerics((PsiClassType)classType);
        if (psiTypes.size() == 1 && (type = (PsiType)psiTypes.get(0)) instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    private static List<SpringBeanPointer> emptyList() {
        return new ArrayList<SpringBeanPointer>();
    }

    public static boolean isAutowiredByDefault(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isAutowiredByDefault"));
        }
        if (!(psiType instanceof PsiClassType)) {
            return false;
        }
        String text = psiType.getCanonicalText();
        if (STANDARD_AUTOWIRED_TYPES.contains(text)) {
            return true;
        }
        for (String standardAutowiredType : STANDARD_AUTOWIRED_TYPES) {
            if (!InheritanceUtil.isInheritor((PsiType)psiType, (String)standardAutowiredType)) continue;
            return true;
        }
        return false;
    }

    static boolean isAutowired(SpringBean springBean, SpringModel springModel, PsiMethod psiMethod) {
        Autowire autowire = springBean.getBeanAutowire();
        switch (autowire) {
            case BY_TYPE: {
                PsiClass psiClass;
                PsiType psiType = psiMethod.getParameterList().getParameters()[0].getType();
                return psiType instanceof PsiClassType && (psiClass = ((PsiClassType)psiType).resolve()) != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
            }
            case BY_NAME: {
                String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod);
                SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)propertyName);
                return bean != null && !bean.isReferenceTo((CommonSpringBean)springBean);
            }
        }
        return false;
    }

    public static Set<String> getAutowiredAnnotations(@Nullable Module module) {
        if (module == null || !SpringAutowireUtil.isUsingAutowiredPostProcessor(module)) {
            return AUTOWIRED_ANNOTATIONS;
        }
        HashSet<String> annotations = new HashSet<String>();
        annotations.addAll(AUTOWIRED_ANNOTATIONS);
        annotations.addAll(SpringAutowireUtil.getCustomAnnotationsFromPostProcessors(module));
        return annotations;
    }

    public static Set<PsiModifierListOwner> getAutowiredMembers(final @NotNull PsiType type, @Nullable Module module) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "getAutowiredMembers"));
        }
        com.intellij.util.containers.HashSet membersCandidate = new com.intellij.util.containers.HashSet();
        if (module != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            Processor<PsiMember> consumer = new Processor<PsiMember>((Set)membersCandidate){
                final /* synthetic */ Set val$membersCandidate;
                {
                    this.val$membersCandidate = set;
                }

                public boolean process(PsiMember member) {
                    block3: {
                        block2: {
                            if (!(member instanceof PsiField)) break block2;
                            PsiType psiType = ((PsiField)member).getType();
                            if (!psiType.isAssignableFrom(type)) break block3;
                            this.val$membersCandidate.add(member);
                            break block3;
                        }
                        if (member instanceof PsiMethod) {
                            for (PsiParameter psiParameter : ((PsiMethod)member).getParameterList().getParameters()) {
                                PsiType psiType = psiParameter.getType();
                                if (!psiType.isAssignableFrom(type)) continue;
                                this.val$membersCandidate.add(member);
                                break;
                            }
                        }
                    }
                    return true;
                }
            };
            HashSet annotations = ContainerUtil.newHashSet(AUTOWIRED_ANNOTATIONS);
            annotations.add("org.springframework.context.annotation.Bean");
            for (String annotation : annotations) {
                PsiClass annoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, scope);
                if (annoClass == null) continue;
                AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)scope).forEach((Processor)consumer);
            }
        }
        return membersCandidate;
    }

    private static Set<String> getCustomAnnotationsFromPostProcessors(@Nullable Module module) {
        if (module == null) {
            return Collections.emptySet();
        }
        PsiClass autowiredPostProcessor = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        if (autowiredPostProcessor == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotations = new HashSet<String>();
        SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)autowiredPostProcessor).withInheritors();
        for (SpringBeanPointer pointer : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
            CommonSpringBean springBean = pointer.getSpringBean();
            if (!(springBean instanceof SpringBean)) continue;
            SpringAutowireUtil.addAutowiredAnnotationType(annotations, springBean);
            SpringAutowireUtil.addAutowiredAnnotationTypes(annotations, springBean);
        }
        return annotations;
    }

    public static boolean isUsingAutowiredPostProcessor(@NotNull Module module) {
        PsiFile[] files;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isUsingAutowiredPostProcessor"));
        }
        String className = ClassUtil.extractClassName((String)"org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        GlobalSearchScope searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scope, (FileType[])new FileType[]{XmlFileType.INSTANCE});
        for (PsiFile file : files = CacheManager.SERVICE.getInstance((Project)module.getProject()).getFilesWithWord(className, (short)255, searchScope, true)) {
            if (!(file instanceof XmlFile) || !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) continue;
            return true;
        }
        return false;
    }

    private static void addAutowiredAnnotationType(@NotNull Set<String> annotations, @NotNull CommonSpringBean springBean) {
        String value;
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredAnnotationType"));
        }
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredAnnotationType"));
        }
        SpringPropertyDefinition autowiredTypeProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"autowiredAnnotationType");
        if (autowiredTypeProperty != null && !StringUtil.isEmptyOrSpaces((String)(value = autowiredTypeProperty.getValueAsString()))) {
            annotations.add(value);
        }
    }

    private static void addAutowiredAnnotationTypes(@NotNull Set<String> annotations, @NotNull CommonSpringBean springBean) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredAnnotationTypes"));
        }
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addAutowiredAnnotationTypes"));
        }
        SpringPropertyDefinition autowiredTypes = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"autowiredAnnotationTypes");
        if (autowiredTypes instanceof SpringProperty) {
            SpringProperty springProperty = (SpringProperty)autowiredTypes;
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getList().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getSet().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getArray().getValues());
        }
    }

    private static void addNotNullValues(@NotNull Collection<String> annotations, @NotNull Collection<SpringValue> values) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addNotNullValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "addNotNullValues"));
        }
        for (SpringValue value : values) {
            String stringValue = value.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)stringValue)) continue;
            annotations.add(stringValue);
        }
    }

    @Nullable
    public static CommonSpringModel getProcessingSpringModel(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
        if (model instanceof CombinedSpringModel) {
            model = SpringAutowireUtil.filterClassRelatedModels((CombinedSpringModel)model, psiClass);
        }
        return SpringAutowireUtil.isEmptyModel(model) ? null : model;
    }

    @NotNull
    private static CommonSpringModel filterClassRelatedModels(@NotNull CombinedSpringModel model, @NotNull PsiClass aClass) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterClassRelatedModels"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterClassRelatedModels"));
        }
        HashSet models = ContainerUtil.newHashSet();
        for (CommonSpringModel commonSpringModel : model.getUnderlyingModels()) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)commonSpringModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)aClass).withInheritors())) continue;
            models.add(commonSpringModel);
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(models, model.getModule());
        if (combinedSpringModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "filterClassRelatedModels"));
        }
        return combinedSpringModelImpl;
    }

    private static boolean isEmptyModel(@NotNull CommonSpringModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "isEmptyModel"));
        }
        return model.equals(SpringModel.UNKNOWN) || model instanceof CombinedSpringModel && ((CombinedSpringModel)model).getUnderlyingModels().isEmpty();
    }

    @NotNull
    private static Set<SpringBeanPointer> excludeOverridenDefaultBeans(@NotNull Set<SpringBeanPointer> pointers) {
        SpringBeanPointer[] objects;
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeOverridenDefaultBeans"));
        }
        if (pointers.size() == 1) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeOverridenDefaultBeans"));
            }
            return set;
        }
        HashSet<SpringBeanPointer> beans = new HashSet<SpringBeanPointer>();
        for (SpringBeanPointer pointer : objects = (SpringBeanPointer[])ArrayUtil.toObjectArray(pointers, SpringBeanPointer.class)) {
            CommonSpringBean bean = pointer.getSpringBean();
            if (SpringAutowireUtil.isOverridden(bean, objects)) continue;
            beans.add(pointer);
        }
        HashSet<SpringBeanPointer> hashSet = beans;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringAutowireUtil", "excludeOverridenDefaultBeans"));
        }
        return hashSet;
    }

    private static boolean isOverridden(CommonSpringBean bean, SpringBeanPointer[] objects) {
        if (bean instanceof SpringImplicitBeanMarker) {
            String beanName = bean.getBeanName();
            PsiClass aClass = bean.getBeanClass();
            if (aClass != null && beanName != null) {
                for (SpringBeanPointer pointer : objects) {
                    if (bean.equals(pointer.getSpringBean()) || !beanName.equals(pointer.getName())) continue;
                    for (PsiClass psiClass : pointer.getEffectiveBeanType()) {
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)aClass, (boolean)true)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

