/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJavaAutowiredMembersInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "checkClass"));
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.web.context.support.SpringBeanAutowiringSupport")) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)aClass)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)aClass);
            if (!info.isStereotypeJavaBean() && !SpringJavaAutowiredMembersInspection.isSpringComponent(aClass, info)) {
                for (PsiField psiField : aClass.getFields()) {
                    SpringJavaAutowiredMembersInspection.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
                }
                for (PsiField psiField : aClass.getMethods()) {
                    SpringJavaAutowiredMembersInspection.checkMemberIsNotAutowired(holder, (PsiMember)psiField);
                }
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private static void checkMemberIsNotAutowired(ProblemsHolder holder, PsiMember psiMember) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Autowired"});
        if (annotation != null) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("class.is.not.spring.bean.autowired", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static boolean isSpringComponent(@NotNull PsiClass aClass, @NotNull SpringJavaClassInfo info) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "isSpringComponent"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "isSpringComponent"));
        }
        return info.isMapped() || SpringJavaAutowiredMembersInspection.isJamSpringComponent(aClass) || SpringJavaAutowiredMembersInspection.isAbstractBaseComponent(aClass);
    }

    private static boolean isJamSpringComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "isJamSpringComponent"));
        }
        return JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass) != null || JamService.getJamService((Project)aClass.getProject()).getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)aClass) != null || SpringJavaAutowiredMembersInspection.isAbstractConfiguration(aClass) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"javax.servlet.annotation.WebServlet", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.test.context.ContextHierarchy", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.beans.factory.annotation.Configurable", (boolean)true) || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.data.repository.Repository");
    }

    private static boolean isAbstractConfiguration(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "isAbstractConfiguration"));
        }
        return aClass.hasModifierProperty("abstract") && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.springframework.context.annotation.Configuration", (boolean)true);
    }

    private static boolean isAbstractBaseComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "isAbstractBaseComponent"));
        }
        final Ref ref = new Ref();
        ref.set((Object)false);
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("abstract")) {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    if (SpringJavaAutowiredMembersInspection.isJamSpringComponent(psiClass)) {
                        ref.set((Object)true);
                        return false;
                    }
                    return true;
                }
            });
        }
        return (Boolean)ref.get();
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaAutowiredMembersInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiredMembersInspection", "getShortName"));
        }
        return "SpringJavaAutowiredMembersInspection";
    }
}

