/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.LightFilePointer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.editor.FileSetEditor;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigureFileSetFix
implements LocalQuickFix {
    protected final Module myModule;
    private final VirtualFile myVirtualFile;

    ConfigureFileSetFix(@NotNull Module module, VirtualFile virtualFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix", "<init>"));
        }
        this.myModule = module;
        this.myVirtualFile = virtualFile;
    }

    @NotNull
    public String getName() {
        String string = SpringBundle.message("spring.facet.inspection.configure.context.for.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix", "applyFix"));
        }
        this.doFix();
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            }
        });
    }

    private void doFix() {
        SpringFileSetImpl fakeNewSet;
        UsageTrigger.trigger((String)"spring.SpringFacetInspection.ConfigureFileSetFix");
        final Ref fileSetsInMultipleModules = Ref.create((Object)Boolean.FALSE);
        final LinkedHashSet<SpringFileSet> sets = new LinkedHashSet<SpringFileSet>();
        ModuleUtilCore.visitMeAndDependentModules((Module)this.myModule, (ModuleUtilCore.ModuleVisitor)new ModuleUtilCore.ModuleVisitor(){

            public boolean visit(Module module) {
                SpringFacet facet = SpringFacet.getInstance((Module)module);
                if (facet != null) {
                    for (SpringFileSet set : SpringFileSetService.getInstance().getAllSets(facet)) {
                        if (set.isAutodetected()) continue;
                        sets.add(set);
                        if (ConfigureFileSetFix.this.myModule.equals(module)) continue;
                        fileSetsInMultipleModules.set((Object)Boolean.TRUE);
                    }
                }
                return true;
            }
        });
        ArrayList<3> list = new ArrayList<3>(sets);
        final SpringFacet facet = SpringFacet.getInstance((Module)this.myModule);
        if (facet != null) {
            fakeNewSet = new SpringFileSetImpl(SpringFileSetService.getInstance().getUniqueId(sets), SpringBundle.message("spring.facet.inspection.context.create", new Object[0]), facet){

                public boolean isNew() {
                    return true;
                }

                protected VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
                    if (url == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix$3", "createVirtualFilePointer"));
                    }
                    return new LightFilePointer(url);
                }
            };
            list.add(fakeNewSet);
        } else {
            fakeNewSet = null;
        }
        BaseListPopupStep<SpringFileSet> step = new BaseListPopupStep<SpringFileSet>(SpringBundle.message("spring.facet.inspection.context.choose", new Object[0]), list){

            public PopupStep onChosen(final SpringFileSet selectedValue, boolean finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        ConfigureFileSetFix.this.onChosen(selectedValue, fakeNewSet, sets, facet);
                    }
                });
            }

            @NotNull
            public String getTextFor(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet) || !((Boolean)fileSetsInMultipleModules.get()).booleanValue()) {
                    String string = fileSet.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix$4", "getTextFor"));
                    }
                    return string;
                }
                Module filesetModule = fileSet.getFacet().getModule();
                String string = fileSet.getName() + " [" + filesetModule.getName() + "]";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix$4", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet)) {
                    return LayeredIcon.create((Icon)fileSet.getIcon(), (Icon)AllIcons.Actions.New);
                }
                return fileSet.getIcon();
            }

            @Nullable
            public ListSeparator getSeparatorAbove(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet)) {
                    return new ListSeparator();
                }
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            private boolean isFakeNewSet(SpringFileSet fileSet) {
                return fileSet.equals((Object)fakeNewSet);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (fakeNewSet != null);
            this.onChosen((SpringFileSet)list.get(0), fakeNewSet, sets, facet);
            return;
        }
        final ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

            public void consume(DataContext context) {
                popup.showInBestPositionFor(context);
            }
        });
    }

    private void onChosen(@Nullable SpringFileSet selectedValue, @Nullable SpringFileSet fakeNewSet, Set<SpringFileSet> existingSets, SpringFacet facet) {
        if (selectedValue == null) {
            return;
        }
        if (selectedValue == fakeNewSet) {
            this.editNewSet(facet, existingSets, fakeNewSet);
            return;
        }
        selectedValue.addFile(this.myVirtualFile);
    }

    private void editNewSet(SpringFacet facet, Set<SpringFileSet> sets, SpringFileSet fakeNewSet) {
        String name = SpringFileSetService.getInstance().getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), sets);
        fakeNewSet.setName(name);
        fakeNewSet.addFile(this.myVirtualFile);
        if (DumbService.isDumb((Project)this.myModule.getProject()) || ApplicationManager.getApplication().isUnitTestMode()) {
            ConfigureFileSetFix.addNewSet(facet, fakeNewSet);
            return;
        }
        FileSetEditor editor = new FileSetEditor(this.myModule, fakeNewSet, new XmlConfigSearcher(this.myModule, false), new CodeConfigSearcher(this.myModule, false));
        if (editor.showAndGet()) {
            ConfigureFileSetFix.addNewSet(facet, editor.getEditedFileSet());
        } else {
            Disposer.dispose((Disposable)fakeNewSet);
        }
    }

    private static void addNewSet(SpringFacet facet, SpringFileSet fileSet) {
        facet.addFileSet(fileSet);
        ((SpringFacetConfiguration)facet.getConfiguration()).setModified();
    }
}

