/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.converters.SpringImportResourceConverterImpl;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationContextReferenceConverter
extends JamSimpleReferenceConverter<List<XmlFile>> {
    public List<XmlFile> fromString(@Nullable String s, JamStringAttributeElement<List<XmlFile>> context) {
        return s == null ? null : SpringImportResourceConverterImpl.getFiles(ApplicationContextReferenceConverter.getReferences(s, context));
    }

    @NotNull
    public static List<XmlFile> getApplicationContexts(@Nullable String path, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getApplicationContexts"));
        }
        List<XmlFile> list = path == null ? Collections.emptyList() : SpringImportResourceConverterImpl.getFiles(ApplicationContextReferenceConverter.getReferencesOnFakeElement(context, path));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getApplicationContexts"));
        }
        return list;
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<List<XmlFile>> context) {
        PsiReference[] psiReferenceArray = ApplicationContextReferenceConverter.getReferences(context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(@NotNull String s, JamStringAttributeElement<List<XmlFile>> context) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getReferences"));
        }
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return ApplicationContextReferenceConverter.getReferencesOnFakeElement((PsiElement)context.getPsiElement(), s);
        }
        return ApplicationContextReferenceConverter.getReferences(psiLiteral, s);
    }

    private static PsiReference[] getReferences(PsiLiteral psiLiteral, String s) {
        SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)psiLiteral, (String)s).fromRoot(s.startsWith("/")).soft(false);
        return SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
    }

    @NotNull
    private static PsiReference[] getReferencesOnFakeElement(@Nullable PsiElement element, @NotNull String s) {
        block7: {
            PsiReference[] psiReferenceArray;
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getReferencesOnFakeElement"));
            }
            if (element == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getReferencesOnFakeElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            try {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
                if (!(psiExpression instanceof PsiLiteral)) break block7;
                psiReferenceArray = ApplicationContextReferenceConverter.getReferences((PsiLiteral)psiExpression, s);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getReferencesOnFakeElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/ApplicationContextReferenceConverter", "getReferencesOnFakeElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferences(JamStringAttributeElement<List<XmlFile>> jamAttribute) {
        PsiLiteral psiLiteral = jamAttribute.getPsiLiteral();
        if (psiLiteral == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = ElementManipulators.getValueText((PsiElement)psiLiteral);
        return ApplicationContextReferenceConverter.getReferences(psiLiteral, s);
    }
}

