/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.testContexts.ApplicationContextReferenceConverter;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomContextConfiguration
implements ContextConfiguration {
    public static final SemKey<JamMemberMeta<PsiClass, CustomContextConfiguration>> META_KEY = SpringContextConfiguration.META.getMetaKey().subKey("CustomContextConfiguration", new SemKey[0]);
    public static final SemKey<CustomContextConfiguration> JAM_KEY = ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY.subKey("CustomContextConfiguration", new SemKey[0]);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private JamAnnotationMeta myAnnotationMeta;
    private final PsiAnchor myPsiClassAnchor;

    public CustomContextConfiguration(@Nullable String anno, @NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "<init>"));
        }
        if (anno != null) {
            this.myAnnotationMeta = new JamAnnotationMeta(anno);
        }
        this.myPsiClassAnchor = PsiAnchor.create((PsiElement)psiClassAnchor);
        this.myPsiAnnotation = this.myAnnotationMeta.getAnnotationRef((PsiModifierListOwner)this.getPsiElement());
    }

    @Override
    public PsiClass getPsiElement() {
        return (PsiClass)this.myPsiClassAnchor.retrieve();
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @NotNull
    public Set<XmlFile> getLocations(PsiClass ... contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "getLocations"));
        }
        HashSet files = ContainerUtil.newHashSet();
        ApplicationContextReferenceConverter referenceConverter = new ApplicationContextReferenceConverter();
        for (String attrName : XML_FILES_ATTRS) {
            JamStringAttributeElement xmlFiles;
            List values;
            SpringAliasFor aliasFor = this.getAliasAttribute(attrName);
            if (aliasFor == null || (values = (List)(xmlFiles = new JamStringAttributeElement(this.myPsiAnnotation, CustomContextConfiguration.getAliasForMethodName(aliasFor), (JamConverter)referenceConverter)).getValue()) == null) continue;
            files.addAll(values);
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "getLocations"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public List<PsiClass> getConfigurationClasses() {
        List psiClasses = ContainerUtil.newSmartList();
        SpringAliasFor aliasFor = this.getAliasAttribute("classes");
        if (aliasFor != null) {
            JamClassAttributeMeta.Collection collection = new JamClassAttributeMeta.Collection(CustomContextConfiguration.getAliasForMethodName(aliasFor));
            for (JamClassAttributeElement classAttributeElement : collection.getJam(this.myPsiAnnotation)) {
                ContainerUtil.addIfNotNull((Object)classAttributeElement.getValue(), (Collection)psiClasses);
            }
        }
        List list = psiClasses;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "getConfigurationClasses"));
        }
        return list;
    }

    @NotNull
    private static String getAliasForMethodName(SpringAliasFor aliasFor) {
        String string = aliasFor.getPsiElement().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "getAliasForMethodName"));
        }
        return string;
    }

    @Override
    public boolean hasLocationsAttribute() {
        return this.getAliasAttribute("locations") != null;
    }

    @Override
    public boolean hasValueAttribute() {
        return this.getAliasAttribute("value") != null;
    }

    @Override
    @Nullable
    public PsiClass getLoaderClass() {
        SpringAliasFor aliasFor = this.getAliasAttribute("loader");
        if (aliasFor != null) {
            return JamAttributeMeta.singleClass((String)CustomContextConfiguration.getAliasForMethodName(aliasFor)).getJam(this.myPsiAnnotation).getValue();
        }
        return null;
    }

    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/jam/testContexts/CustomContextConfiguration", "getAliasAttribute"));
        }
        return SpringAliasForUtils.findAliasFor(this.getPsiElement().getProject(), this.myAnnotationMeta.getAnnoName(), "org.springframework.test.context.ContextConfiguration", attrName);
    }
}

