/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.testContexts.ApplicationContextReferenceConverter;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringActiveProfiles;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringContextConfiguration
implements ContextConfiguration {
    public static final SemKey<SpringContextConfiguration> JAM_KEY = ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY.subKey("SpringContextConfiguration", new SemKey[0]);
    public static final JamClassMeta<SpringContextConfiguration> META = new JamClassMeta(null, SpringContextConfiguration.class, JAM_KEY);
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.test.context.ContextConfiguration");
    public static final JamClassAttributeMeta.Single LOADER_ATTR_META = JamAttributeMeta.singleClass((String)"loader");
    public static final JamStringAttributeMeta.Collection<List<XmlFile>> LOCATION_ATTR_META = JamAttributeMeta.collectionString((String)"locations", (JamConverter)new ApplicationContextReferenceConverter());
    public static final JamStringAttributeMeta.Collection<List<XmlFile>> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new ApplicationContextReferenceConverter());
    protected static final JamClassAttributeMeta.Collection CLASSES_ATTR_META = new JamClassAttributeMeta.Collection("classes");
    protected static final JamClassAttributeMeta.Collection INITIALIZERS_ATTR_META = new JamClassAttributeMeta.Collection("initializers");
    private final PsiClass myPsiClass;
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public SpringContextConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "<init>"));
        }
        this.myPsiClass = psiClass;
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiClass);
    }

    public SpringContextConfiguration(PsiAnnotation annotation) {
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
        this.myPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class, (boolean)true);
    }

    @NotNull
    public JamClassAttributeElement getLoaderAttributeElement() {
        JamClassAttributeElement jamClassAttributeElement = LOADER_ATTR_META.getJam(this.myPsiAnnotation);
        if (jamClassAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getLoaderAttributeElement"));
        }
        return jamClassAttributeElement;
    }

    @NotNull
    public List<JamStringAttributeElement<List<XmlFile>>> getLocationsAttributeElement() {
        List list = LOCATION_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getLocationsAttributeElement"));
        }
        return list;
    }

    @NotNull
    public List<JamStringAttributeElement<List<XmlFile>>> getValueAttributeElement() {
        List list = VALUE_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getValueAttributeElement"));
        }
        return list;
    }

    public boolean isInheritLocations() {
        PsiAnnotation annotation = this.getAnnotation();
        Boolean value = annotation == null ? null : (Boolean)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)annotation.findAttributeValue("inheritLocations"), Boolean.class);
        return value == null || value != false;
    }

    @Override
    @Nullable
    public PsiClass getPsiElement() {
        return this.myPsiClass;
    }

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @NotNull
    public Set<XmlFile> getLocations(PsiClass ... contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getLocations"));
        }
        HashSet locations = new HashSet();
        this.addFiles(contexts, (Set<XmlFile>)locations, this.getValueAttributeElement());
        this.addFiles(contexts, (Set<XmlFile>)locations, this.getLocationsAttributeElement());
        HashSet hashSet = locations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getLocations"));
        }
        return hashSet;
    }

    private void addFiles(@NotNull PsiClass[] contexts, @NotNull Set<XmlFile> locations, @NotNull List<JamStringAttributeElement<List<XmlFile>>> elements) {
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "addFiles"));
        }
        if (locations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "addFiles"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "addFiles"));
        }
        for (JamStringAttributeElement<List<XmlFile>> stringAttributeElement : elements) {
            for (PsiClass context : contexts) {
                if (context.equals(this.getPsiElement())) {
                    List xmlFiles = (List)stringAttributeElement.getValue();
                    if (xmlFiles == null) continue;
                    locations.addAll(xmlFiles);
                    continue;
                }
                String value = stringAttributeElement.getStringValue();
                if (value == null) continue;
                locations.addAll(ApplicationContextReferenceConverter.getApplicationContexts(value, (PsiElement)context));
            }
        }
    }

    @Override
    @NotNull
    public List<PsiClass> getConfigurationClasses() {
        SmartList imported = new SmartList();
        for (JamClassAttributeElement jamClassAttributeElement : CLASSES_ATTR_META.getJam(this.myPsiAnnotation)) {
            ContainerUtil.addIfNotNull((Collection)imported, (Object)jamClassAttributeElement.getValue());
        }
        if (imported.isEmpty()) {
            SpringContextConfiguration.addDefaultConfigurations(this.myPsiClass, (List<PsiClass>)imported);
        }
        SmartList smartList = imported;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getConfigurationClasses"));
        }
        return smartList;
    }

    private static void addDefaultConfigurations(@NotNull PsiClass owner, @NotNull List<PsiClass> psiClasses) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "addDefaultConfigurations"));
        }
        if (psiClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClasses", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "addDefaultConfigurations"));
        }
        for (PsiClass psiClass : owner.getAllInnerClasses()) {
            if (!psiClass.hasModifierProperty("static") || !SpringContextConfiguration.isConfiguration(psiClass)) continue;
            psiClasses.add(psiClass);
        }
    }

    private static boolean isConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "isConfiguration"));
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null;
    }

    public PsiElementRef<PsiAnnotation> getAnnoRef() {
        return ANNO_META.getAnnotationRef((PsiModifierListOwner)this.getPsiElement());
    }

    public Set<String> getActiveProfiles() {
        SpringActiveProfiles profiles = SpringContextConfiguration.getSpringActiveProfiles(this.getPsiElement());
        return profiles != null ? profiles.getActiveProfiles() : Collections.emptySet();
    }

    @Nullable
    public static SpringActiveProfiles getSpringActiveProfiles(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringContextConfiguration", "getSpringActiveProfiles"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (boolean)true, (String[])new String[]{"org.springframework.test.context.ActiveProfiles"});
        if (annotation != null) {
            return new SpringActiveProfiles(psiClass);
        }
        return null;
    }

    @Override
    public boolean hasLocationsAttribute() {
        return !this.getLocationsAttributeElement().isEmpty();
    }

    @Override
    public boolean hasValueAttribute() {
        return !this.getValueAttributeElement().isEmpty();
    }

    @Override
    @Nullable
    public PsiClass getLoaderClass() {
        return this.getLoaderAttributeElement().getValue();
    }

    static {
        META.addAnnotation(ANNO_META);
        ANNO_META.addAttribute(LOCATION_ATTR_META);
        ANNO_META.addAttribute(VALUE_ATTR_META);
        ANNO_META.addAttribute((JamAttributeMeta)CLASSES_ATTR_META);
        ANNO_META.addAttribute((JamAttributeMeta)INITIALIZERS_ATTR_META);
    }
}

