/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringTestingModel
extends SpringModel
implements CommonSpringModel {
    private Set<String> myActiveProfiles;
    private final PsiClass myTestClass;

    public SpringTestingModel(@NotNull PsiClass testClass, @NotNull Module module) {
        if (testClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "<init>"));
        }
        super(module);
        this.myTestClass = testClass;
    }

    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        if (this.myActiveProfiles == null) {
            this.myActiveProfiles = SpringTestContextUtilImpl.discoverTestContextActiveProfiles(this.myTestClass);
        }
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getActiveProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getAllProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        Set<CommonSpringModel> set = SpringTestContextUtilImpl.getSpringContextConfigurationModels(this.myTestClass, this.getModule(), this.getActiveProfiles());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getModelsToProcess"));
        }
        return set;
    }
}

