/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJamUtilsImpl
extends SpringJamUtils {
    private static final Key<CachedValue<Set<CommonSpringBean>>> ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE = Key.create((String)"ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE");

    @NotNull
    private static Map<SpringBean, Set<CommonSpringBean>> getAnnotationConfigAppContextedBeans(@NotNull CommonSpringModel model, @NotNull Module module) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotationConfigAppContextedBeans"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotationConfigAppContextedBeans"));
        }
        HashMap ac = new HashMap();
        for (SpringBeanPointer appConfig : model.getAnnotationConfigApplicationContexts()) {
            CommonSpringBean commonSpringBean = appConfig.getSpringBean();
            if (!(commonSpringBean instanceof SpringBean)) continue;
            SpringBean springBean = (SpringBean)commonSpringBean;
            ac.put(springBean, SpringJamUtilsImpl.getAnnotationAppContextBeans(module, springBean));
        }
        HashMap hashMap = ac;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotationConfigAppContextedBeans"));
        }
        return hashMap;
    }

    private static Set<CommonSpringBean> getAnnotationAppContextBeans(final Module module, final SpringBean springBean) {
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)springBean, ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE, (CachedValueProvider)new CachedValueProvider<Set<CommonSpringBean>>(){

            public CachedValueProvider.Result<Set<CommonSpringBean>> compute() {
                LinkedHashSet set = ContainerUtil.newLinkedHashSet();
                Set allConstructorArgs = springBean.getAllConstructorArgs();
                if (allConstructorArgs.size() == 1) {
                    set.addAll(SpringJamUtilsImpl.getAnnotatedStereotypes((ConstructorArg)allConstructorArgs.iterator().next(), module));
                }
                return CachedValueProvider.Result.create((Object)set, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    @NotNull
    private static Set<CommonSpringBean> getAnnotatedStereotypes(@NotNull ConstructorArg arg, @NotNull Module module) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotatedStereotypes"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotatedStereotypes"));
        }
        Set<String> names = SpringJamUtilsImpl.collectNames(arg);
        if (names.isEmpty()) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotatedStereotypes"));
            }
            return set;
        }
        LinkedHashSet stereotypeElements = ContainerUtil.newLinkedHashSet();
        for (CommonSpringBean stereotypeElement : SpringJamModel.getModel((Module)module).getStereotypeComponents()) {
            PsiElement aClass = stereotypeElement.getIdentifyingPsiElement();
            if (!(aClass instanceof PsiClass) || !SpringJamUtilsImpl.isStereotypeAccepted((PsiClass)aClass, names)) continue;
            stereotypeElements.add(stereotypeElement);
        }
        LinkedHashSet linkedHashSet = stereotypeElements;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getAnnotatedStereotypes"));
        }
        return linkedHashSet;
    }

    private static boolean isStereotypeAccepted(@NotNull PsiClass aClass, @NotNull Set<String> names) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "isStereotypeAccepted"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "isStereotypeAccepted"));
        }
        String fqn = aClass.getQualifiedName();
        if (fqn == null) {
            return false;
        }
        for (String classOrPackageName : names) {
            if (!fqn.startsWith(classOrPackageName) && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)classOrPackageName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<CommonModelElement> findStereotypeConfigurationBeans(@NotNull CommonSpringModel model, @NotNull List<? extends SpringBeanPointer> beansInModel, @Nullable Module module) {
        Collection<Object> stereotypeElements;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "findStereotypeConfigurationBeans"));
        }
        if (beansInModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beansInModel", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "findStereotypeConfigurationBeans"));
        }
        if (module == null) {
            Set<CommonModelElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "findStereotypeConfigurationBeans"));
            }
            return set;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (Map.Entry<SpringBeansPackagesScan, List<CommonSpringBean>> entry : SpringJamUtilsImpl.getComponentScannedBeans(model, module).entrySet()) {
            for (SpringBeanPointer springBeanPointer : beansInModel) {
                stereotypeElements = entry.getValue();
                if (!stereotypeElements.contains(springBeanPointer.getSpringBean())) continue;
                result.add(entry.getKey());
            }
        }
        for (Map.Entry<Object, Collection<CommonSpringBean>> entry : SpringJamUtilsImpl.getAnnotationConfigAppContextedBeans(model, module).entrySet()) {
            for (SpringBeanPointer springBeanPointer : beansInModel) {
                stereotypeElements = (Set)entry.getValue();
                if (!stereotypeElements.contains(springBeanPointer.getSpringBean())) continue;
                result.add(entry.getKey());
            }
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "findStereotypeConfigurationBeans"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> collectNames(@NotNull ConstructorArg arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "collectNames"));
        }
        LinkedHashSet strings = ContainerUtil.newLinkedHashSet();
        if (DomUtil.hasXml((DomElement)arg.getValueAttr())) {
            SpringJamUtilsImpl.addIfNotNull(strings, arg.getValueAttr().getStringValue());
        }
        if (DomUtil.hasXml((DomElement)arg.getValue())) {
            SpringJamUtilsImpl.addIfNotNull(strings, arg.getValue().getStringValue());
        }
        for (String s : SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)arg)) {
            SpringJamUtilsImpl.addIfNotNull(strings, s);
        }
        LinkedHashSet linkedHashSet = strings;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "collectNames"));
        }
        return linkedHashSet;
    }

    private static void addIfNotNull(@NotNull Set<String> strings, String s) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "addIfNotNull"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)s)) {
            strings.add(s);
        }
    }

    private static Map<SpringBeansPackagesScan, List<CommonSpringBean>> getComponentScannedBeans(@NotNull CommonSpringModel model, @NotNull Module module) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getComponentScannedBeans"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getComponentScannedBeans"));
        }
        HashMap cs = new HashMap();
        for (SpringBeansPackagesScan packagesScan : model.getComponentScans()) {
            cs.put(packagesScan, SpringProfileUtils.filterBeansInActiveProfiles(new ArrayList(packagesScan.getScannedElements(module)), (Set)model.getActiveProfiles()));
        }
        return cs;
    }

    @NotNull
    public Set<CommonSpringBean> filterComponentScannedStereotypes(@NotNull Module module, @NotNull SpringBeansPackagesScan componentScan, @NotNull List<? extends CommonSpringBean> allComponents) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (componentScan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentScan", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (allComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allComponents", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        Set psiPackages = componentScan.getPsiPackages();
        if (psiPackages.isEmpty()) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
            }
            return set;
        }
        Set<CommonSpringBean> set = this.filterComponentScannedStereotypes(module, allComponents, psiPackages, componentScan.useDefaultFilters(), componentScan.getExcludeContextFilters(), componentScan.getIncludeContextFilters());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        return set;
    }

    public Set<CommonSpringBean> filterComponentScannedStereotypes(@NotNull Module module, @NotNull List<? extends CommonSpringBean> allComponents, @NotNull Set<PsiPackage> psiPackages, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (allComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allComponents", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (psiPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackages", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (excludeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeContextFilters", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        if (includeContextFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeContextFilters", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterComponentScannedStereotypes"));
        }
        ArrayList includeFiltered = new ArrayList();
        for (SpringContextFilter.Include includeFilter : includeContextFilters) {
            includeFiltered.addAll(includeFilter.includeStereotypes(module, psiPackages));
        }
        LinkedHashSet resultElements = ContainerUtil.newLinkedHashSet();
        if (useDefaultFilters) {
            resultElements.addAll(SpringJamUtilsImpl.filterStereotypeComponents(allComponents, excludeContextFilters, psiPackages));
        }
        resultElements.addAll(SpringJamUtilsImpl.filterStereotypeComponents(includeFiltered, excludeContextFilters, psiPackages));
        return resultElements;
    }

    @NotNull
    public List<ContextJavaBean> getContextBeans(@NotNull PsiClass beanClass, @Nullable Set<String> activeProfiles) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getContextBeans"));
        }
        List<ContextJavaBean> contextJavaBeans = SpringJamUtilsImpl.doGetContextBeans(beanClass);
        List list = SpringProfileUtils.filterBeansInActiveProfiles(contextJavaBeans, activeProfiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getContextBeans"));
        }
        return list;
    }

    private static List<ContextJavaBean> doGetContextBeans(PsiClass beanClass) {
        return JamService.getJamService((Project)beanClass.getProject()).getAnnotatedMembersList(beanClass, ContextJavaBean.BEAN_JAM_KEY, false, true, false, true);
    }

    @Nullable
    public SpringStereotypeElement findStereotypeElement(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "findStereotypeElement"));
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        List stereotypeMappedBeans = info.getStereotypeMappedBeans();
        for (JamSpringBeanPointer pointer : stereotypeMappedBeans) {
            JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)pointer.getSpringBean();
            if (!(bean instanceof SpringStereotypeElement)) continue;
            return (SpringStereotypeElement)bean;
        }
        return null;
    }

    private static boolean isInPackage(@NotNull Set<PsiPackage> psiPackages, PsiClass psiClass) {
        if (psiPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackages", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "isInPackage"));
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            for (PsiPackage psiPackage : psiPackages) {
                if (!StringUtil.startsWithConcatenation((String)qualifiedName, (String[])new String[]{psiPackage.getQualifiedName(), "."})) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Set<XmlFile> getImportedResources(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedResources"));
        }
        SpringImportResource importResource = (SpringImportResource)SpringImportResource.META.getJamElement((PsiModifierListOwner)psiClass);
        if (importResource == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedResources"));
            }
            return set;
        }
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet(importResource.getImportedResources());
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedResources"));
        }
        return linkedHashSet;
    }

    public boolean processImportedResources(@NotNull PsiClass psiClass, @NotNull Processor<Pair<List<XmlFile>, ? extends PsiElement>> processor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processImportedResources"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processImportedResources"));
        }
        SpringImportResource importResource = (SpringImportResource)SpringImportResource.META.getJamElement((PsiModifierListOwner)psiClass);
        if (importResource == null) {
            return true;
        }
        return importResource.processImportedResources(processor);
    }

    @NotNull
    public Set<PsiClass> getImportedClasses(@NotNull PsiClass clazz, @Nullable Module module) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedClasses"));
        }
        SpringImport springImport = (SpringImport)SpringImport.META.getJamElement((PsiModifierListOwner)clazz);
        if (springImport == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedClasses"));
            }
            return set;
        }
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet(springImport.getImportedClasses());
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getImportedClasses"));
        }
        return linkedHashSet;
    }

    public boolean processImportedClasses(@NotNull PsiClass clazz, @NotNull Processor<Pair<PsiClass, ? extends PsiElement>> processor) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processImportedClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processImportedClasses"));
        }
        SpringImport springImport = (SpringImport)SpringImport.META.getJamElement((PsiModifierListOwner)clazz);
        if (springImport == null) {
            return true;
        }
        return springImport.processImportedClasses(processor);
    }

    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getComponentScans"));
        }
        SpringComponentScan componentScan = (SpringComponentScan)JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)psiClass);
        List<Object> list = componentScan == null ? Collections.emptyList() : Collections.singletonList(componentScan);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getComponentScans"));
        }
        return list;
    }

    @Nullable
    public SpringPropertySource getSpringPropertySource(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getSpringPropertySource"));
        }
        return (SpringPropertySource)SpringPropertySource.META.getJamElement((PsiModifierListOwner)psiClass);
    }

    @NotNull
    private static List<CommonSpringBean> filterStereotypeComponents(@NotNull List<? extends CommonSpringBean> components, @NotNull Set<SpringContextFilter.Exclude> excludeFilters, @NotNull Set<PsiPackage> psiPackages) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterStereotypeComponents"));
        }
        if (excludeFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFilters", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterStereotypeComponents"));
        }
        if (psiPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackages", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterStereotypeComponents"));
        }
        ArrayList<CommonSpringBean> filtered = new ArrayList<CommonSpringBean>();
        for (CommonSpringBean commonSpringBean : components) {
            PsiClass psiClass = commonSpringBean.getBeanClass();
            if (psiClass == null || !SpringJamUtilsImpl.isInPackage(psiPackages, psiClass)) continue;
            boolean exclude = false;
            for (SpringContextFilter.Exclude excludeFilter : excludeFilters) {
                if (!excludeFilter.exclude(psiClass)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            filtered.add(commonSpringBean);
        }
        ArrayList<CommonSpringBean> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "filterStereotypeComponents"));
        }
        return arrayList;
    }

    @NotNull
    public Set<PsiClass> getEnabledAnnotations(@NotNull PsiClass classToProcess) {
        if (classToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToProcess", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getEnabledAnnotations"));
        }
        final LinkedHashSet enabledAnnotations = ContainerUtil.newLinkedHashSet();
        this.processEnabledAnnotations(classToProcess, new Processor<Pair<PsiClass, LocalModelDependency>>(){

            public boolean process(Pair<PsiClass, LocalModelDependency> pair) {
                enabledAnnotations.add(pair.first);
                return true;
            }
        });
        LinkedHashSet linkedHashSet = enabledAnnotations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "getEnabledAnnotations"));
        }
        return linkedHashSet;
    }

    public boolean processEnabledAnnotations(@NotNull PsiClass psiClass, @NotNull Processor<Pair<PsiClass, LocalModelDependency>> processor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processEnabledAnnotations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl", "processEnabledAnnotations"));
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                LocalModelDependency dependency;
                PsiClass annotationClass;
                String name = psiAnnotation.getQualifiedName();
                if (name == null || !StringUtil.getShortName((String)name).startsWith("Enable") || (annotationClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(name, psiClass.getResolveScope())) == null || processor.process((Object)Pair.create((Object)annotationClass, (Object)(dependency = LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.ENABLE_ANNO, (PsiElement)psiAnnotation.getOriginalElement()))))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<LocalModel, LocalModelDependency> processor) {
        for (LocalAnnotationModelDependentModelsProvider provider : (LocalAnnotationModelDependentModelsProvider[])LocalAnnotationModelDependentModelsProvider.EP_NAME.getExtensions()) {
            if (provider.processCustomDependentLocalModels(localAnnotationModel, processor)) continue;
            return false;
        }
        return true;
    }
}

