/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.properties;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.properties.PropertyReferenceSet;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    private final PropertyReferenceSet myReferenceSet;
    private final int myIndex;

    public PropertyReference(PropertyReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, true);
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @Nullable
    private PsiClass getPsiClass() {
        PsiMethod method;
        PsiType type;
        if (this.isFirst()) {
            return this.myReferenceSet.getBeanClass();
        }
        Object[] results = ((PropertyReference)this.myReferenceSet.getReference(this.myIndex - 1)).multiResolve(false);
        if (results.length > 0 && (type = (method = PropertyReference.chooseMethod(ContainerUtil.map2List((Object[])results, (Function)new NullableFunction<ResolveResult, PsiMethod>(){

            public PsiMethod fun(ResolveResult resolveResult) {
                return (PsiMethod)resolveResult.getElement();
            }
        }))).getReturnType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    private Set<PsiMethod> getSharedProperties(@NotNull Collection<SpringBeanPointer> descendants) {
        if (descendants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendants", "com/intellij/spring/model/properties/PropertyReference", "getSharedProperties"));
        }
        Set<PsiClass> beanClasses = PropertyReference.getUniqueBeanClasses(descendants);
        boolean acceptSetters = this.isLast();
        HashSet<PsiMethod> maps = new HashSet<PsiMethod>();
        String propertyName = this.getValue();
        for (PsiClass beanClass : beanClasses) {
            if (acceptSetters) {
                maps.addAll(PropertyUtil.getSetters((PsiClass)beanClass, (String)propertyName));
                continue;
            }
            maps.addAll(PropertyUtil.getGetters((PsiClass)beanClass, (String)propertyName));
        }
        return maps;
    }

    private static PsiMethod chooseMethod(List<PsiMethod> methods) {
        int methodsCount = methods.size();
        if (methodsCount == 1) {
            return methods.get(0);
        }
        PsiMethod chosenMethod = methods.get(0);
        for (int i = 1; i < methodsCount; ++i) {
            PsiMethod method = methods.get(i);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)chosenMethod.getContainingClass(), (PsiClass)method.getContainingClass(), (boolean)true)) continue;
            chosenMethod = method;
        }
        return chosenMethod;
    }

    private Map<String, Set<PsiMethod>> getAllSharedProperties(@NotNull Collection<SpringBeanPointer> descendants) {
        if (descendants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendants", "com/intellij/spring/model/properties/PropertyReference", "getAllSharedProperties"));
        }
        Set<PsiClass> beanClasses = PropertyReference.getUniqueBeanClasses(descendants);
        boolean acceptGetters = !this.isLast();
        ArrayList maps = new ArrayList();
        for (PsiClass beanClass : beanClasses) {
            maps.add(PropertyUtil.getAllProperties((PsiClass)beanClass, (boolean)true, (boolean)acceptGetters));
        }
        return PropertyReference.reduce(maps);
    }

    @Nullable
    public PsiMethod resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return (PsiMethod)(resolveResults.length == 1 ? resolveResults[0].getElement() : null);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String propertyName;
        PsiMethod method;
        if (this.isFirst()) {
            SpringModel model = SpringConverterUtil.getSpringModel((ConvertContext)this.myReferenceSet.getContext());
            if (model == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "multiResolve"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            List<SpringBeanPointer> descendants = this.getDescendants(model);
            if (descendants.isEmpty()) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "multiResolve"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            Set<PsiMethod> methods = this.getSharedProperties(descendants);
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(methods);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null && (method = this.resolve(psiClass, propertyName = this.getValue())) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)method)};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "multiResolve"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    private List<SpringBeanPointer> getDescendants(SpringModel model) {
        return model.getDescendants(BeanService.getInstance().createSpringBeanPointer(this.myReferenceSet.getBean()));
    }

    @Nullable
    private PsiMethod resolve(PsiClass psiClass, String propertyName) {
        boolean isLast = this.isLast();
        PsiMethod method = isLast ? PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true) : PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        return method == null || !method.hasModifierProperty("public") ? null : method;
    }

    private boolean isLast() {
        return this.myReferenceSet.getReferences().size() - 1 == this.myIndex;
    }

    private boolean isFirst() {
        return this.myIndex == 0;
    }

    @NotNull
    public Object[] getVariants() {
        String propertyName;
        Map<String, PsiMethod> properties;
        SpringModel model = SpringConverterUtil.getSpringModel((ConvertContext)this.myReferenceSet.getContext());
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        CommonSpringBean bean = this.myReferenceSet.getBean();
        if (!this.isFirst()) {
            PsiClass psiClass = this.getPsiClass();
            if (psiClass == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
            properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
        } else {
            List<SpringBeanPointer> descendants = this.getDescendants(model);
            if (!descendants.isEmpty()) {
                Map<String, Set<PsiMethod>> sharedProperties = this.getAllSharedProperties(descendants);
                properties = new HashMap();
                for (Map.Entry<String, Set<PsiMethod>> entry : sharedProperties.entrySet()) {
                    propertyName = entry.getKey();
                    PsiMethod firstMethod = entry.getValue().iterator().next();
                    properties.put(propertyName, firstMethod);
                }
            } else {
                PsiClass psiClass = this.getPsiClass();
                if (psiClass == null) {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getVariants"));
                    }
                    return EMPTY_ARRAY;
                }
                properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
            }
        }
        List<String> existingPropertyNames = PropertyReference.getExistingPropertyNames(bean);
        com.intellij.util.containers.HashSet variants = new com.intellij.util.containers.HashSet();
        for (Map.Entry<String, Set<Object>> entry : properties.entrySet()) {
            propertyName = entry.getKey();
            if (existingPropertyNames.contains(propertyName)) continue;
            PsiMethod psiMethod = (PsiMethod)entry.getValue();
            PsiType propertyType = PropertyUtil.getPropertyType((PsiMember)psiMethod);
            assert (propertyType != null);
            variants.add(LookupElementBuilder.create((Object)psiMethod, (String)propertyName).withIcon(SpringApiIcons.SpringProperty).withStrikeoutness(psiMethod.isDeprecated()).withTypeText(propertyType.getPresentableText()));
        }
        Object[] objectArray = variants.toArray(new LookupElementBuilder[variants.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    private static List<String> getExistingPropertyNames(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/properties/PropertyReference", "getExistingPropertyNames"));
        }
        List list = ContainerUtil.map((Collection)SpringPropertyUtils.getProperties((CommonSpringBean)bean), (Function)new Function<SpringPropertyDefinition, String>(){

            public String fun(SpringPropertyDefinition definition) {
                return definition.getPropertyName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getExistingPropertyNames"));
        }
        return list;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtil.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/properties/PropertyReference", "bindToElement"));
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    @NotNull
    private static Set<PsiClass> getUniqueBeanClasses(@NotNull Collection<SpringBeanPointer> beans) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/properties/PropertyReference", "getUniqueBeanClasses"));
        }
        if (beans.isEmpty()) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getUniqueBeanClasses"));
            }
            return set;
        }
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (SpringBeanPointer bean : beans) {
            PsiClass psiClass = bean.getBeanClass();
            if (psiClass == null) continue;
            classes.add(psiClass);
        }
        HashSet<PsiClass> hashSet = classes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getUniqueBeanClasses"));
        }
        return hashSet;
    }

    @NotNull
    private static <K, V> Map<K, Set<V>> reduce(@NotNull Collection<Map<K, V>> maps) {
        if (maps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maps", "com/intellij/spring/model/properties/PropertyReference", "reduce"));
        }
        HashMap intersection = new HashMap();
        Iterator<Map<K, V>> i = maps.iterator();
        if (i.hasNext()) {
            Map<K, V> first = i.next();
            for (Map.Entry<K, V> entry : first.entrySet()) {
                HashSet<V> values = new HashSet<V>();
                values.add(entry.getValue());
                intersection.put(entry.getKey(), values);
            }
            while (i.hasNext()) {
                Map<K, V> map = i.next();
                intersection.keySet().retainAll(map.keySet());
                for (Map.Entry entry : intersection.entrySet()) {
                    ((Set)entry.getValue()).add(map.get(entry.getKey()));
                }
            }
        }
        HashMap hashMap = intersection;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "reduce"));
        }
        return hashMap;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringBundle.message("model.property.error.message", this.getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public LocalQuickFix[] getQuickFixes() {
        PsiClass psiClass;
        String value = this.getValue();
        if (StringUtil.isNotEmpty((String)value) && (psiClass = this.getPsiClass()) != null) {
            SpringPropertyDefinition definition = (SpringPropertyDefinition)this.myReferenceSet.getGenericDomValue().getParent();
            assert (definition != null);
            PsiType type = definition.guessTypeByValue();
            return CreateBeanPropertyFix.createFixes((String)value, (PsiClass)psiClass, (PsiType)type, (boolean)true);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }
}

