/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.PNamespaceValue;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinitionBase;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PNamespaceValueImpl
extends SpringValueHolderDefinitionBase
implements PNamespaceValue {
    private static final NullableFunction<PsiMethod, PsiType> PROPERTY_TYPE = new NullableFunction<PsiMethod, PsiType>(){

        public PsiType fun(PsiMethod psiMethod) {
            return PropertyUtil.getPropertyType((PsiMember)psiMethod);
        }
    };

    @NotNull
    public List<PsiType> getRequiredTypes() {
        List<PsiType> list = PNamespaceValueImpl.getPropertyType((DomElement)this, this.getPropertyName());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/PNamespaceValueImpl", "getRequiredTypes"));
        }
        return list;
    }

    @NotNull
    static List<PsiType> getPropertyType(DomElement value, @NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/xml/beans/impl/PNamespaceValueImpl", "getPropertyType"));
        }
        SpringBean bean = (SpringBean)value.getParent();
        assert (bean != null);
        PsiClass beanClass = bean.getBeanClass();
        if (beanClass == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/PNamespaceValueImpl", "getPropertyType"));
            }
            return list;
        }
        List methods = PropertyUtil.getSetters((PsiClass)beanClass, (String)name);
        List list = ContainerUtil.map2List((Collection)methods, PROPERTY_TYPE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/PNamespaceValueImpl", "getPropertyType"));
        }
        return list;
    }

    @NotNull
    @NonNls
    public String getPropertyName() {
        String string = this.getXmlElementName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/PNamespaceValueImpl", "getPropertyName"));
        }
        return string;
    }

    @Nullable
    public PsiType guessTypeByValue() {
        return null;
    }

    @Nullable
    public GenericDomValue<SpringBeanPointer> getRefElement() {
        DomAttributeChildDescription description = this.getParent().getGenericInfo().getAttributeChildDescription(this.getPropertyName() + "-ref");
        return description == null ? null : description.getDomAttributeValue(this.getParent());
    }

    @Nullable
    public GenericDomValue<?> getValueElement() {
        return this;
    }
}

