/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverterImpl;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanImpl;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringDomQualifier;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.impl.ResolvedConstructorArgsImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanImpl
extends DomSpringBeanImpl
implements SpringBean {
    public static final Function<SpringBean, Collection<SpringPropertyDefinition>> PROPERTIES_GETTER = new Function<SpringBean, Collection<SpringPropertyDefinition>>(){

        public Collection<SpringPropertyDefinition> fun(SpringBean springBean) {
            return SpringPropertyUtils.getProperties((CommonSpringBean)springBean);
        }
    };
    public static final Function<SpringBean, Collection<ConstructorArg>> CTOR_ARGS_GETTER = new Function<SpringBean, Collection<ConstructorArg>>(){

        public Collection<ConstructorArg> fun(SpringBean springBean) {
            return springBean.getConstructorArgs();
        }
    };

    @Nullable
    public PsiClass getInstantiationClass() {
        PsiMethod factoryMethod;
        GenericAttributeValue<PsiMethod> factoryMethodAttribute = this.getFactoryMethod();
        if (DomUtil.hasXml(factoryMethodAttribute) && (factoryMethod = (PsiMethod)factoryMethodAttribute.getValue()) != null) {
            return SpringBeanFactoryMethodConverterImpl.getFactoryClass(this);
        }
        return this.getBeanClass();
    }

    @NotNull
    public List<PsiMethod> getInstantiationMethods() {
        String factoryMethod;
        GenericAttributeValue<PsiMethod> factoryMethodAttribute = this.getFactoryMethod();
        if (DomUtil.hasXml(factoryMethodAttribute) && (factoryMethod = factoryMethodAttribute.getStringValue()) != null) {
            List<PsiMethod> list = SpringBeanFactoryMethodConverterImpl.getFactoryMethodCandidates(this, factoryMethod);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getInstantiationMethods"));
            }
            return list;
        }
        PsiClass beanClass = this.getBeanClass();
        if (beanClass != null) {
            List<PsiMethod> list = Arrays.asList(beanClass.getConstructors());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getInstantiationMethods"));
            }
            return list;
        }
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getInstantiationMethods"));
        }
        return list;
    }

    @Nullable
    public String getBeanName() {
        if (DomUtil.hasXml((DomElement)this.getId())) {
            return this.getId().getRawText();
        }
        GenericAttributeValue nameAttribute = this.getName();
        if (!DomUtil.hasXml((DomElement)nameAttribute)) {
            return null;
        }
        String name = nameAttribute.getRawText();
        if (name != null) {
            List list = SpringCommonUtils.tokenize((String)name);
            return (String)ContainerUtil.getFirstItem((List)list);
        }
        return null;
    }

    @NotNull
    public String[] getAliases() {
        String name = this.getName().getRawText();
        if (name != null) {
            List list = SpringCommonUtils.tokenize((String)name);
            String id = this.getId().getStringValue();
            if (id == null && list.size() > 1) {
                list.remove(0);
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)list);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getAliases"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "setName"));
        }
        String id = this.getId().getStringValue();
        if (id != null) {
            this.getId().setStringValue(newName);
            return;
        }
        String name = this.getName().getStringValue();
        if (name != null) {
            int first = StringUtil.findFirst((CharSequence)name, (CharFilter)SpringCommonUtils.ourFilter);
            if (first >= 0) {
                String newValue = newName + name.substring(first);
                this.getName().setStringValue(newValue);
            } else {
                this.getName().setStringValue(newName);
            }
            return;
        }
        this.getId().setValue((Object)newName);
    }

    @NotNull
    public abstract GenericAttributeValue<SpringBeanPointer> getFactoryBean();

    @NotNull
    public abstract GenericAttributeValue<PsiMethod> getFactoryMethod();

    @Nullable
    public PsiClass getBeanClass(@Nullable Set<AbstractDomSpringBean> visited, boolean considerFactories) {
        SpringBeanPointer parent;
        if (visited != null && visited.contains((Object)this)) {
            return null;
        }
        PsiClass psiClass = super.getBeanClass(visited, considerFactories);
        if (psiClass != null) {
            return psiClass;
        }
        GenericAttributeValue parentBeanValue = this.getParentBean();
        if (DomUtil.hasXml((DomElement)parentBeanValue) && (parent = (SpringBeanPointer)parentBeanValue.getValue()) != null) {
            if (visited == null) {
                visited = new THashSet();
            }
            visited.add((AbstractDomSpringBean)this);
            CommonSpringBean bean = parent.getSpringBean();
            if (bean instanceof DomSpringBeanImpl) {
                return ((DomSpringBeanImpl)bean).getBeanClass((Set)visited, considerFactories);
            }
        }
        return null;
    }

    public List<SpringPropertyDefinition> getAllProperties() {
        Set<SpringPropertyDefinition> list = SpringBeanCoreUtils.getMergedSet(this, PROPERTIES_GETTER);
        return list.isEmpty() ? Collections.emptyList() : new ArrayList<SpringPropertyDefinition>(list);
    }

    public SpringPropertyDefinition getProperty(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getProperty"));
        }
        final Ref ref = new Ref();
        SpringBeanCoreUtils.visitParents(this, false, new Processor<SpringBean>(){

            public boolean process(SpringBean springBean) {
                List properties = SpringPropertyUtils.getProperties((CommonSpringBean)springBean);
                for (SpringPropertyDefinition property : properties) {
                    if (!name.equals(property.getPropertyName())) continue;
                    ref.set((Object)property);
                    return false;
                }
                return true;
            }
        });
        return (SpringPropertyDefinition)ref.get();
    }

    public Set<ConstructorArg> getAllConstructorArgs() {
        return SpringBeanCoreUtils.getMergedSet(this, CTOR_ARGS_GETTER);
    }

    @NotNull
    public ResolvedConstructorArgs getResolvedConstructorArgs() {
        ResolvedConstructorArgs resolvedConstructorArgs = (ResolvedConstructorArgs)CachedValuesManager.getManager((Project)this.getManager().getProject()).getCachedValue((UserDataHolder)this, (CachedValueProvider)new CachedValueProvider<ResolvedConstructorArgsImpl>(){

            @Nullable
            public CachedValueProvider.Result<ResolvedConstructorArgsImpl> compute() {
                return CachedValueProvider.Result.createSingleDependency((Object)new ResolvedConstructorArgsImpl(SpringBeanImpl.this), (Object)PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        });
        if (resolvedConstructorArgs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getResolvedConstructorArgs"));
        }
        return resolvedConstructorArgs;
    }

    @NotNull
    public List<CNamespaceDomElement> getCNamespaceConstructorArgDefinitions() {
        List list = DomUtil.getDefinedChildrenOfType((DomElement)this, CNamespaceDomElement.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getCNamespaceConstructorArgDefinitions"));
        }
        return list;
    }

    public boolean isAbstract() {
        GenericAttributeValue abstractAttribute = this.getAbstract();
        if (!DomUtil.hasXml((DomElement)abstractAttribute)) {
            return false;
        }
        Boolean value = (Boolean)abstractAttribute.getValue();
        return value != null && value != false;
    }

    @NotNull
    public Autowire getBeanAutowire() {
        Autowire autowire;
        GenericAttributeValue autowireAttribute = this.getAutowire();
        Autowire autowire2 = autowire = DomUtil.hasXml((DomElement)autowireAttribute) ? (Autowire)autowireAttribute.getValue() : null;
        if (autowire == null) {
            Beans beans = (Beans)this.getParentOfType(Beans.class, false);
            assert (beans != null);
            GenericAttributeValue defaultAutowireAttribute = beans.getDefaultAutowire();
            Autowire autowire3 = autowire = DomUtil.hasXml((DomElement)defaultAutowireAttribute) ? (Autowire)defaultAutowireAttribute.getValue() : null;
            if (autowire == null) {
                Autowire autowire4 = Autowire.DEFAULT;
                if (autowire4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getBeanAutowire"));
                }
                return autowire4;
            }
        }
        if (autowire == Autowire.AUTODETECT) {
            Autowire autowire5 = SpringConstructorArgResolveUtil.hasEmptyConstructor(this) ? Autowire.BY_TYPE : Autowire.CONSTRUCTOR;
            if (autowire5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getBeanAutowire"));
            }
            return autowire5;
        }
        Autowire autowire6 = autowire;
        if (autowire6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl", "getBeanAutowire"));
        }
        return autowire6;
    }

    @NonNls
    public String toString() {
        String beanName = this.getBeanName();
        return beanName == null ? "Unknown" + ((Object)((Object)this)).hashCode() : beanName;
    }

    public SpringQualifier getSpringQualifier() {
        PsiClass aClass;
        SpringDomQualifier qualifier = this.getQualifier();
        if (DomUtil.hasXml((DomElement)qualifier)) {
            return qualifier;
        }
        Module module = this.getModule();
        if (module != null && (aClass = this.getBeanClass()) != null) {
            return SpringJamQualifier.findSpringJamQualifier((Module)module, (PsiModifierListOwner)aClass);
        }
        return null;
    }

    public boolean isPrimary() {
        GenericAttributeValue primaryAttribute = this.getPrimary();
        if (!DomUtil.hasXml((DomElement)primaryAttribute)) {
            return super.isPrimary();
        }
        Boolean primary = (Boolean)primaryAttribute.getValue();
        return primary == null ? super.isPrimary() : primary.booleanValue();
    }
}

