/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.custom.CustomBeanFakePsiElement;
import com.intellij.spring.model.xml.custom.CustomBeanInfo;
import com.intellij.spring.model.xml.custom.CustomBeanRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomNamespaceSpringBean
extends AbstractDomSpringBean
implements CustomBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.xml.custom.CustomNamespaceSpringBean");
    private final CustomBeanInfo myInfo;
    private final Module myModule;
    private final XmlTag mySourceTag;
    private final PsiElement myFakePsi;
    private final CustomBeanWrapper myWrapper;
    private final XmlAttribute myIdAttribute;

    public CustomNamespaceSpringBean(@NotNull CustomBeanInfo info, Module module, @NotNull CustomBeanWrapper wrapper) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "<init>"));
        }
        this.myInfo = info;
        this.myModule = module;
        this.myWrapper = wrapper;
        XmlTag tag = wrapper.getXmlTag();
        if (tag == null) {
            LOG.error(String.valueOf(wrapper.getParent()));
        }
        this.mySourceTag = tag = CustomBeanRegistry.getActualSourceTag(info, tag);
        this.myIdAttribute = this.mySourceTag.getAttribute(info.idAttribute);
        this.myFakePsi = new CustomBeanFakePsiElement(this);
    }

    @Nullable
    public XmlAttribute getIdAttribute() {
        return this.myIdAttribute;
    }

    @Nullable
    public GenericValue<SpringBeanPointer> getFactoryBean() {
        SpringBeanPointer beanPointer;
        SpringModel model;
        String beanName = this.myInfo.factoryBeanName;
        if (beanName != null && (model = SpringManager.getInstance((Project)this.getPsiManager().getProject()).getSpringModelByFile(this.getContainingFile())) != null && (beanPointer = SpringBeanUtils.getInstance().findBean((CommonSpringModel)model, beanName)) != null) {
            return ReadOnlyGenericValue.getInstance((Object)beanPointer);
        }
        return super.getFactoryBean();
    }

    @NotNull
    public CustomBeanWrapper getWrapper() {
        CustomBeanWrapper customBeanWrapper = this.myWrapper;
        if (customBeanWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "getWrapper"));
        }
        return customBeanWrapper;
    }

    @Nullable
    public GenericValue<PsiMethod> getFactoryMethod() {
        PsiMethod method;
        PsiClass beanClass;
        String name = this.myInfo.factoryMethodName;
        if (name != null && (beanClass = this.getBeanClass(false)) != null && (method = this.findMatchingFactoryMethod(name, beanClass)) != null) {
            return ReadOnlyGenericValue.getInstance((Object)method);
        }
        return super.getFactoryMethod();
    }

    @Nullable
    private PsiMethod findMatchingFactoryMethod(String name, PsiClass beanClass) {
        PsiMethod result = null;
        Object returnType = null;
        int count = this.myInfo.constructorArgumentCount;
        for (PsiMethod method : beanClass.findMethodsByName(name, true)) {
            if (method.getParameterList().getParametersCount() != count || !method.hasModifierProperty("static")) continue;
            if (returnType == null) {
                result = method;
                returnType = method.getReturnType();
                continue;
            }
            if (returnType.equals(method.getReturnType())) continue;
            return null;
        }
        return result;
    }

    @Nullable
    public String getBeanName() {
        return this.myInfo.beanName;
    }

    @NotNull
    public String[] getAliases() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean isValid() {
        return this.mySourceTag.isValid();
    }

    @NotNull
    public XmlTag getXmlTag() {
        XmlTag xmlTag = this.mySourceTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "getXmlTag"));
        }
        return xmlTag;
    }

    public PsiManager getPsiManager() {
        return this.mySourceTag.getManager();
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        return this.myFakePsi;
    }

    @NotNull
    public final PsiFile getContainingFile() {
        PsiFile psiFile = this.mySourceTag.getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean", "getContainingFile"));
        }
        return psiFile;
    }

    @Nullable
    public String getClassName() {
        return this.myInfo.beanClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomNamespaceSpringBean that = (CustomNamespaceSpringBean)((Object)o);
        if (!this.myInfo.equals(that.myInfo)) {
            return false;
        }
        return this.myWrapper.equals(that.myWrapper);
    }

    public int hashCode() {
        int result = this.myInfo.hashCode();
        result = 31 * result + this.myWrapper.hashCode();
        return result;
    }

    public Beans getBeansParent() {
        return (Beans)DomUtil.getParentOfType((DomElement)this.getWrapper(), Beans.class, (boolean)false);
    }
}

