/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramEdge
extends DiagramEdgeBase<SpringElementWrapper> {
    private final SpringDependencyType myDependencyType;

    public SpringDiagramEdge(DiagramNode<SpringElementWrapper> source, DiagramNode<SpringElementWrapper> target, SpringDependencyType dependencyType) {
        this(source, target, dependencyType, null);
    }

    public SpringDiagramEdge(DiagramNode<SpringElementWrapper> source, DiagramNode<SpringElementWrapper> target, SpringDependencyType dependencyType, @Nullable String label) {
        super(source, target, SpringDiagramEdge.getInfo(dependencyType, label));
        this.myDependencyType = dependencyType;
    }

    public SpringDependencyType getDependencyType() {
        return this.myDependencyType;
    }

    private static DiagramRelationshipInfo getInfo(final SpringDependencyType type, @Nullable String label) {
        String name = SpringDiagramEdge.getRelationshipName(type);
        return new DiagramRelationshipInfoAdapter(name, SpringDiagramEdge.getLineType(type), label == null ? name : label){

            public Shape getStartArrow() {
                if (type == SpringDependencyType.PARENT) {
                    return DELTA;
                }
                if (type == SpringDependencyType.INNER) {
                    return INNER_CLASS_ARROW;
                }
                if (type == SpringDependencyType.SCANNED) {
                    return DELTA_SMALL;
                }
                if (type == SpringDependencyType.MESSAGE_FLOW_UNKNOWN) {
                    return NONE;
                }
                return STANDARD;
            }
        };
    }

    private static DiagramLineType getLineType(SpringDependencyType type) {
        switch (type) {
            case PROPERTY_INJECTION: 
            case CONSTRUCTOR_INJECTION: 
            case LOOKUP_METHOD_INJECTION: 
            case FACTORY_BEAN: 
            case PARENT: 
            case DEPENDS_ON: 
            case INNER: 
            case MESSAGE_FLOW: {
                return DiagramLineType.SOLID;
            }
            case SCANNED: {
                return DiagramLineType.DOTTED;
            }
            case AUTOWIRE: 
            case ANNO_AUTOWIRED: 
            case ANNO_RESOURCE_AUTOWIRED: 
            case ANNO_INJECT_AUTOWIRED: 
            case UNKNOWN: {
                return DiagramLineType.DASHED;
            }
        }
        return DiagramLineType.DOTTED;
    }

    private static String getRelationshipName(SpringDependencyType type) {
        switch (type) {
            case PROPERTY_INJECTION: 
            case CONSTRUCTOR_INJECTION: 
            case LOOKUP_METHOD_INJECTION: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.injected", new Object[0]);
            }
            case FACTORY_BEAN: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.creates", new Object[0]);
            }
            case DEPENDS_ON: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.depends.on", new Object[0]);
            }
            case AUTOWIRE: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.autowired", new Object[0]);
            }
            case ANNO_AUTOWIRED: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.anno.autowired", new Object[0]);
            }
            case ANNO_RESOURCE_AUTOWIRED: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.anno.resource.autowired", new Object[0]);
            }
            case ANNO_INJECT_AUTOWIRED: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.anno.inject.autowired", new Object[0]);
            }
            case PARENT: {
                return SpringBundle.message("spring.bean.dependency.graph.edge.inherits", new Object[0]);
            }
            case UNKNOWN: {
                break;
            }
            case INNER: {
                break;
            }
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringDiagramEdge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpringDiagramEdge that = (SpringDiagramEdge)((Object)o);
        return this.myDependencyType == that.myDependencyType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myDependencyType.hashCode();
        return result;
    }
}

