/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesUtil;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.edges.ByTypeAutowire;
import com.intellij.spring.perspectives.diagrams.edges.InjectionEdge;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramEdgeCreationUtil {
    private static int ourTestModeXmlBeanInjectionOptionIndex = -1;

    public static DiagramEdgeCreationPolicy<SpringElementWrapper> getDiagramEdgeCreationPolicy() {
        return new DiagramEdgeCreationPolicy<SpringElementWrapper>(){

            public boolean acceptSource(@NotNull DiagramNode<SpringElementWrapper> source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/spring/perspectives/diagrams/SpringDiagramEdgeCreationUtil$1", "acceptSource"));
                }
                SpringElementWrapper identifyingElement = (SpringElementWrapper)source.getIdentifyingElement();
                if (identifyingElement instanceof SpringBeanPointerWrapper) {
                    DomSpringBean bean;
                    PsiFile containingFile;
                    SpringBeanPointer wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
                    if (wrapped instanceof JamSpringBeanPointer) {
                        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)wrapped).getSpringBean();
                        if (memberSpringBean instanceof JamPsiClassSpringBean) {
                            PsiClass psiClass = ((JamPsiClassSpringBean)memberSpringBean).getPsiElement();
                            return !(psiClass instanceof PsiCompiledElement) && !psiClass.isInterface();
                        }
                    } else if (wrapped instanceof DomSpringBeanPointer && (containingFile = (bean = (DomSpringBean)wrapped.getSpringBean()).getContainingFile()) != null) {
                        VirtualFile file = containingFile.getVirtualFile();
                        return file != null && !(file.getFileSystem() instanceof JarFileSystem);
                    }
                }
                return false;
            }

            public boolean acceptTarget(@NotNull DiagramNode<SpringElementWrapper> target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/perspectives/diagrams/SpringDiagramEdgeCreationUtil$1", "acceptTarget"));
                }
                return true;
            }
        };
    }

    @Nullable
    public static DiagramEdge<SpringElementWrapper> createEdge(@NotNull DiagramNode<SpringElementWrapper> source, @NotNull DiagramNode<SpringElementWrapper> target, Collection<DiagramEdge<SpringElementWrapper>> edges, DiagramBuilder builder, @Nullable CommonSpringModel applicationModel) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/spring/perspectives/diagrams/SpringDiagramEdgeCreationUtil", "createEdge"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/perspectives/diagrams/SpringDiagramEdgeCreationUtil", "createEdge"));
        }
        for (DiagramEdge<SpringElementWrapper> edge : edges) {
            if (!edge.getSource().equals(source) || !edge.getTarget().equals(target)) continue;
            return null;
        }
        SpringElementWrapper identifyingElement = (SpringElementWrapper)source.getIdentifyingElement();
        if (identifyingElement instanceof SpringBeanPointerWrapper) {
            DomSpringBean bean;
            SpringBeanPointer wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            if (wrapped instanceof JamSpringBeanPointer) {
                JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)wrapped).getSpringBean();
                if (memberSpringBean instanceof JamPsiClassSpringBean) {
                    PsiClass psiClass = ((JamPsiClassSpringBean)memberSpringBean).getPsiElement();
                    return SpringDiagramEdgeCreationUtil.createJavaClassEdge(source, target, psiClass, builder, applicationModel);
                }
            } else if (wrapped instanceof DomSpringBeanPointer && (bean = (DomSpringBean)wrapped.getSpringBean()) instanceof SpringBean) {
                return SpringDiagramEdgeCreationUtil.createXmlBeanInjectionEdge(source, target, (SpringBean)bean, builder, applicationModel);
            }
        }
        return null;
    }

    static void setTestModeXmlBeanInjectionOptionIndex(int index) {
        ourTestModeXmlBeanInjectionOptionIndex = index;
    }

    @Nullable
    private static DiagramEdge<SpringElementWrapper> createXmlBeanInjectionEdge(final DiagramNode<SpringElementWrapper> source, final DiagramNode<SpringElementWrapper> target, final SpringBean bean, DiagramBuilder builder, final CommonSpringModel applicationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)target.getIdentifyingElement();
        if (wrapper instanceof SpringBeanPointerWrapper) {
            final SpringBeanPointer targetPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)wrapper).getWrapped();
            Callable<DiagramEdge<SpringElementWrapper>> callable = new Callable<DiagramEdge<SpringElementWrapper>>(){

                @Override
                public DiagramEdge<SpringElementWrapper> call() throws Exception {
                    int index;
                    PsiClass beanClass = bean.getBeanClass();
                    Object[] names = new String[]{"Setter Injection", "Constructor Injection"};
                    if (!(beanClass instanceof PsiCompiledElement)) {
                        names = (String[])ArrayUtil.append((Object[])names, (Object)"@Autowired");
                    }
                    int n = index = ApplicationManager.getApplication().isUnitTestMode() ? ourTestModeXmlBeanInjectionOptionIndex : Messages.showChooseDialog((String)"Dependency Type", (String)"Choose Dependency Type", (String[])names, (String)names[0], null);
                    if (index == -1) {
                        return null;
                    }
                    if (index == 2) {
                        List<SpringGenerateTemplatesHolder> pairs;
                        if (beanClass != null && (pairs = GenerateAutowiredDependenciesUtil.generateAutowiredDependencies(beanClass, Collections.singletonList(targetPointer), applicationModel)).size() == 1) {
                            pairs.get(0).runTemplates();
                            return new ByTypeAutowire((DiagramNode<SpringElementWrapper>)source, (DiagramNode<SpringElementWrapper>)target);
                        }
                    } else {
                        List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> pairs = GenerateSpringBeanDependenciesUtil.generateDependencies(bean, Collections.singletonList(targetPointer), index == 0);
                        if (pairs.size() == 1) {
                            Pair<SpringInjection, SpringGenerateTemplatesHolder> pair = pairs.get(0);
                            SpringInjection injection = (SpringInjection)pair.first;
                            if (injection != null) {
                                ((SpringGenerateTemplatesHolder)pair.second).runTemplates();
                                return new InjectionEdge((DiagramNode<SpringElementWrapper>)source, (DiagramNode<SpringElementWrapper>)target, (DomElement)injection);
                            }
                        }
                    }
                    if (beanClass instanceof PsiCompiledElement) {
                        Messages.showMessageDialog((String)"Can't create dependency for compiled class", (String)"Compiled Class Dependency", null);
                    }
                    return null;
                }
            };
            return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)builder, (Callable)callable, (String)"Add Spring Bean Dependencies", null, (PsiElement[])new PsiElement[]{bean.getContainingFile(), targetPointer.getContainingFile()});
        }
        return null;
    }

    @Nullable
    private static DiagramEdge<SpringElementWrapper> createJavaClassEdge(final DiagramNode<SpringElementWrapper> source, final DiagramNode<SpringElementWrapper> target, final PsiClass aClass, DiagramBuilder builder, final CommonSpringModel applicationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)target.getIdentifyingElement();
        if (wrapper instanceof SpringBeanPointerWrapper) {
            final SpringBeanPointer targetPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)wrapper).getWrapped();
            Callable<DiagramEdge<SpringElementWrapper>> callable = new Callable<DiagramEdge<SpringElementWrapper>>(){

                @Override
                public DiagramEdge<SpringElementWrapper> call() throws Exception {
                    List<SpringGenerateTemplatesHolder> pairs;
                    if (aClass != null && (pairs = GenerateAutowiredDependenciesUtil.generateAutowiredDependencies(aClass, Collections.singletonList(targetPointer), applicationModel)).size() == 1) {
                        pairs.get(0).runTemplates();
                        return new ByTypeAutowire((DiagramNode<SpringElementWrapper>)source, (DiagramNode<SpringElementWrapper>)target);
                    }
                    return null;
                }
            };
            return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)builder, (Callable)callable, (String)"Add Spring Bean Dependencies", null, (PsiElement[])new PsiElement[]{targetPointer.getContainingFile()});
        }
        return null;
    }
}

