/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.perspectives.diagrams.beans.SpringAppContextWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanClassWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.ui.SimpleColoredText;
import icons.SpringApiIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramElementManager
extends AbstractDiagramElementManager<SpringElementWrapper> {
    public SpringElementWrapper findInDataContext(DataContext context) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            return new SpringAppContextWrapper((XmlFile)psiFile);
        }
        return SpringDiagramElementManager.findBeanPointer((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context));
    }

    @Nullable
    private static SpringElementWrapper findBeanPointer(@Nullable PsiElement element) {
        SpringJavaClassInfo info;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass) && ((info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass)).isStereotypeJavaBean() || info.isMappedDomBean())) {
            return new SpringBeanClassWrapper(psiClass);
        }
        return null;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof SpringElementWrapper;
    }

    public String getElementTitle(SpringElementWrapper element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object obj, DiagramState presentation) {
        SpringBeanPointer element;
        if (obj instanceof SpringBeanPointerWrapper && (element = (SpringBeanPointer)((SpringBeanPointerWrapper)obj).getWrapped()).isValid()) {
            String beanName = SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)element);
            return new SimpleColoredText(SpringDiagramElementManager.getShotBeanName(beanName), DEFAULT_TITLE_ATTR);
        }
        if (obj instanceof SpringProperty) {
            String name = ((SpringProperty)obj).getName().getRawText();
            return new SimpleColoredText(name, DEFAULT_TEXT_ATTR);
        }
        if (obj instanceof SpringElementWrapper) {
            return new SimpleColoredText(((SpringElementWrapper)obj).getName(), DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    private static String getShotBeanName(String beanName) {
        if (!beanName.startsWith("<") && beanName.contains(".")) {
            return StringUtil.getShortName((String)beanName);
        }
        return beanName;
    }

    public String getNodeTooltip(SpringElementWrapper element) {
        if (element instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)element.getWrapped();
            PsiClass aClass = beanPointer.getBeanClass();
            if (aClass != null) {
                return aClass.getQualifiedName();
            }
            return SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)beanPointer);
        }
        return element.getName();
    }

    public Object[] getNodeItems(SpringElementWrapper parent) {
        CommonSpringBean springBean;
        SpringBeanPointer wrapped;
        ArrayList children = new ArrayList();
        if (parent instanceof SpringBeanPointerWrapper && (wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)parent).getWrapped()).isValid() && (springBean = wrapped.getSpringBean()) instanceof SpringBean) {
            SpringBean bean = (SpringBean)springBean;
            children.addAll(bean.getProperties());
            children.addAll(bean.getConstructorArgs());
        }
        return children.toArray();
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof SpringProperty) {
            return SpringApiIcons.SpringProperty;
        }
        return super.getItemIcon(element, presentation);
    }
}

