/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.options.SpringEditorOptions;
import com.intellij.spring.profiles.SpringProfilesPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfilesEditorNotificationsProvider
extends EditorNotifications.Provider<SpringProfilesPanel> {
    private final Project myProject;
    private static final Key<SpringProfilesPanel> KEY = Key.create((String)"SpringProfilesPanelKey");

    public SpringProfilesEditorNotificationsProvider(Project project) {
        this.myProject = project;
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomFileElement domFileElement = (DomFileElement)DomUtil.getParentOfType((DomElement)element, DomFileElement.class, (boolean)false);
                if (domFileElement != null && domFileElement.isValid() && domFileElement.getRootElement() instanceof Beans) {
                    EditorNotifications.getInstance((Project)SpringProfilesEditorNotificationsProvider.this.myProject).updateAllNotifications();
                }
            }
        }, (Disposable)project);
    }

    @NotNull
    public Key<SpringProfilesPanel> getKey() {
        Key<SpringProfilesPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "getKey"));
        }
        return key;
    }

    public SpringProfilesPanel createNotificationPanel(final @NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (!SpringEditorOptions.getInstance().isShowProfilesPanel()) {
            return null;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorNotifications.getInstance((Project)SpringProfilesEditorNotificationsProvider.this.myProject).updateNotifications(file);
                }
            });
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        SpringModel springModel = this.getSpringModel(psiFile);
        if (springModel == null || springModel.getFileSet() == null) {
            return null;
        }
        Set<String> allProfiles = SpringProfilesEditorNotificationsProvider.filterNonProfiles(springModel.getAllProfiles());
        Set activeProfiles = springModel.getActiveProfiles();
        if (allProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(allProfiles.iterator().next()) && (activeProfiles == null || activeProfiles.isEmpty())) {
            return null;
        }
        if (allProfiles.isEmpty()) {
            return null;
        }
        return new SpringProfilesPanel(psiFile, allProfiles, activeProfiles, SpringProfilesEditorNotificationsProvider.isFileInActiveProfile(psiFile, springModel));
    }

    @NotNull
    private static Set<String> filterNonProfiles(@NotNull Set<String> profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "filterNonProfiles"));
        }
        Set set = ContainerUtil.map2Set(profiles, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.startsWith("!") ? s.substring(1) : s;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "filterNonProfiles"));
        }
        return set;
    }

    private static boolean isFileInActiveProfile(PsiFile file, SpringModel model) {
        if (file instanceof XmlFile) {
            return true;
        }
        return model.hasConfigFile(file);
    }

    @Nullable
    private SpringModel getSpringModel(PsiFile psiFile) {
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            SpringManager springManager = SpringManager.getInstance((Project)this.myProject);
            return springManager.getSpringModelByFile(psiFile);
        }
        if (psiFile instanceof PsiClassOwner) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            if (!SpringProfilesEditorNotificationsProvider.hasConfigurations((PsiClassOwner)psiFile)) {
                return null;
            }
            SpringManager springManager = SpringManager.getInstance((Project)this.myProject);
            Set models = springManager.getAllModels(module);
            for (SpringModel model : models) {
                for (CommonSpringModel localModel : model.getModelsToProcess(false)) {
                    if (!localModel.hasConfigFile(psiFile)) continue;
                    return model;
                }
            }
        }
        return null;
    }

    private static boolean hasConfigurations(PsiClassOwner psiFile) {
        for (PsiClass psiClass : psiFile.getClasses()) {
            if (!SpringProfilesEditorNotificationsProvider.containsConfigurations(psiClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider", "containsConfigurations"));
        }
        if (SpringCommonUtils.isConfiguration((PsiClass)psiClass)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInnerClasses()) {
            if (!SpringProfilesEditorNotificationsProvider.containsConfigurations(aClass)) continue;
            return true;
        }
        return false;
    }
}

