/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.util.ArrayUtil;
import icons.SpringApiIcons;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfilesPanel
extends SpringEditorNotificationPanel {
    private final PsiFile myPsiFile;
    private final Color myBackground;

    public SpringProfilesPanel(PsiFile psiFile, final @NotNull Set<String> allProfiles, final @Nullable Set<String> activeProfiles, boolean isActive) {
        if (allProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allProfiles", "com/intellij/spring/profiles/SpringProfilesPanel", "<init>"));
        }
        this.myPsiFile = psiFile;
        this.myBackground = isActive ? LightColors.SLIGHTLY_GREEN : LightColors.SLIGHTLY_GRAY;
        String profilesText = SpringProfileUtils.profilesAsString(activeProfiles);
        this.text(profilesText);
        this.icon(SpringApiIcons.SpringProfile);
        this.myLabel.setToolTipText(SpringBundle.message("editor.panel.profiles.tooltip", new Object[0]));
        this.createActionLabel(SpringBundle.message("editor.panel.profiles.tooltip.action.name", new Object[0]), new Runnable(){

            @Override
            public void run() {
                Set myActiveProfiles = activeProfiles == null ? new HashSet() : activeProfiles;
                HashSet profilesToShow = new HashSet(allProfiles);
                profilesToShow.addAll(myActiveProfiles);
                final LinkedHashSet<JCheckBox> checkBoxes = new LinkedHashSet<JCheckBox>();
                Object[] profiles = ArrayUtil.toStringArray(profilesToShow);
                Arrays.sort(profiles);
                for (Object profileName : profiles) {
                    if ("_DEFAULT_PROFILE_NAME_".equals(profileName)) continue;
                    checkBoxes.add(new JCheckBox((String)profileName, myActiveProfiles.contains(profileName)));
                }
                CheckBoxList profilesCheckBoxList = new CheckBoxList();
                profilesCheckBoxList.setModel((ListModel)new CollectionListModel((Object[])checkBoxes.toArray(new JCheckBox[checkBoxes.size()])));
                final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)profilesCheckBoxList, (JComponent)profilesCheckBoxList).setRequestFocus(true).setAdText("Press Enter to apply").addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        if (!event.isOk()) {
                            return;
                        }
                        HashSet<String> updatedSelection = new HashSet<String>();
                        for (JCheckBox box : checkBoxes) {
                            if (!box.isSelected()) continue;
                            updatedSelection.add(box.getText());
                        }
                        SpringProfilesPanel.this.updateActiveProfileSelection(updatedSelection);
                    }
                }).createPopup();
                AnAction ok = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        popup.closeOk(e.getInputEvent());
                    }
                };
                ok.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)profilesCheckBoxList);
                popup.showUnderneathOf(SpringProfilesPanel.this.myLinksPanel.getComponent(0));
            }
        });
        this.installOpenEditorSettingsButton(this.myPsiFile.getProject());
    }

    private void updateActiveProfileSelection(Set<String> updatedSelection) {
        SpringModel springModel;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiFile);
        SpringManager springManager = SpringManager.getInstance((Project)this.myPsiFile.getProject());
        if (module != null) {
            Set models = springManager.getAllModels(module);
            block0: for (SpringModel springModel2 : models) {
                Set modelsToProcess = springModel2.getModelsToProcess(false);
                for (CommonSpringModel commonSpringModel : modelsToProcess) {
                    if (!commonSpringModel.hasConfigFile(this.myPsiFile)) continue;
                    this.updateSpringModel(springModel2, updatedSelection);
                    continue block0;
                }
            }
        } else if (this.myPsiFile instanceof XmlFile && (springModel = springManager.getSpringModelByFile(this.myPsiFile)) != null) {
            this.updateSpringModel(springModel, updatedSelection);
        }
    }

    private void updateSpringModel(SpringModel springModel, Set<String> profiles) {
        SpringFileSet fileSet = springModel.getFileSet();
        if (fileSet != null) {
            fileSet.setActiveProfiles(profiles);
        }
        UsageTrigger.trigger((String)"spring.SpringChangeActiveProfiles");
        Project project = this.myPsiFile.getProject();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        SpringModificationTrackersManager.getInstance((Project)project).fireActiveProfilesChanged();
        ((PsiModificationTrackerImpl)this.myPsiFile.getManager().getModificationTracker()).incCounter();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public Color getBackground() {
        return this.myBackground;
    }
}

