/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringBeansModulesPanel;
import com.intellij.ui.FinderRecursivePanel;
import gnu.trove.THashSet;
import icons.SpringApiIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringBeansView
extends SpringBaseView {
    private static final String TAB_ID = "Beans";
    private DefaultActionGroup myStructureViewActionGroup;
    private DefaultActionGroup myConfigurationViewActionGroup;
    private DefaultActionGroup myPresentationActionGroup;

    public SpringBeansView(Project project) {
        super(project);
        this.installToolbar();
        this.installSettingsListener();
        this.installProjectModuleListener();
    }

    protected FinderRecursivePanel createRootPanel() {
        if (this.getSettings().isShowModules()) {
            return new SpringBeansModulesPanel(this.myProject, this.getStructureViewActionGroup());
        }
        return this.createSpringBeansProjectPanel();
    }

    static void selectIn(Project project, Object[] pathToSelect, boolean requestFocus) {
        SpringBeansView.select((Project)project, (Object[])pathToSelect, (boolean)requestFocus, (String)TAB_ID);
    }

    private SpringBeansViewSettings getSettings() {
        return SpringBeansViewSettings.getInstance(this.myProject);
    }

    private SpringBeanPointerFinderRecursivePanel createSpringBeansProjectPanel() {
        NullableFactory<CommonSpringModel> factory = new NullableFactory<CommonSpringModel>(){

            public CommonSpringModel create() {
                return new BeansSpringModel(null, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        Module[] modules;
                        THashSet allBeans = new THashSet();
                        for (Module module : modules = ModuleManager.getInstance((Project)SpringBeansView.this.myProject).getModules()) {
                            for (SpringModel model : SpringManager.getInstance((Project)SpringBeansView.this.myProject).getAllModelsWithoutDependencies(module)) {
                                Collection beans = model.getAllCommonBeans();
                                allBeans.addAll(beans);
                            }
                        }
                        THashSet tHashSet = allBeans;
                        if (tHashSet == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/SpringBeansView$1$1", "compute"));
                        }
                        return tHashSet;
                    }
                });
            }
        };
        return new SpringBeanPointerFinderRecursivePanel(this.myProject, "SpringBeanPointerFinderRecursivePanel", factory);
    }

    private void installToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.getStructureViewActionGroup());
        group.addSeparator();
        group.add((AnAction)this.getConfigurationViewActionGroup());
        group.addSeparator();
        group.add((AnAction)this.getPresentationActionGroup());
        group.addSeparator();
        group.add((AnAction)new ContextHelpAction("Reference.Spring.ToolWindow"));
        this.setToolbar(ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(SpringBeansViewSettings.TOPIC, (Object)new SpringBeansViewSettings.Listener(){

            @Override
            public void settingsChanged(SpringBeansViewSettings.ChangeType changeType) {
                if (changeType == SpringBeansViewSettings.ChangeType.FULL) {
                    SpringBeansView.this.performFullUpdate();
                } else if (changeType == SpringBeansViewSettings.ChangeType.UPDATE_DETAILS) {
                    SpringBeansView.this.performDetailsUpdate();
                } else if (changeType == SpringBeansViewSettings.ChangeType.UPDATE_LIST) {
                    SpringBeansView.this.myRootPanel.updatePanel();
                } else if (changeType == SpringBeansViewSettings.ChangeType.FORCE_UPDATE_RIGHT_COMPONENT) {
                    SpringBeansView.this.myRootPanel.updateRightComponent(true);
                }
            }
        });
    }

    @NotNull
    public DefaultActionGroup getStructureViewActionGroup() {
        if (this.myStructureViewActionGroup == null) {
            this.myStructureViewActionGroup = new DefaultActionGroup();
            this.myStructureViewActionGroup.add((AnAction)new ToggleAction("Show modules", null, AllIcons.ObjectBrowser.ShowModules){

                public boolean isSelected(AnActionEvent e) {
                    return SpringBeansView.this.getSettings().isShowModules();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    SpringBeansViewSettings settings = SpringBeansView.this.getSettings();
                    settings.setShowModules(state);
                    settings.fireSettingsChanged(SpringBeansViewSettings.ChangeType.FULL);
                }
            });
        }
        DefaultActionGroup defaultActionGroup = this.myStructureViewActionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/SpringBeansView", "getStructureViewActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public DefaultActionGroup getConfigurationViewActionGroup() {
        if (this.myConfigurationViewActionGroup == null) {
            this.myConfigurationViewActionGroup = new DefaultActionGroup();
            this.myConfigurationViewActionGroup.add((AnAction)new ToggleAction("Show Implicit Beans", null, SpringApiIcons.ImplicitBean){

                public boolean isSelected(AnActionEvent e) {
                    return SpringBeansView.this.getSettings().isShowImplicitBeans();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    SpringBeansView.this.getSettings().setShowImplicitBeans(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_LIST);
                }
            });
            this.myConfigurationViewActionGroup.add((AnAction)new ToggleAction("Show Infrastructure Beans", null, SpringApiIcons.InfrastructureBean){

                public boolean isSelected(AnActionEvent e) {
                    return SpringBeansView.this.getSettings().isShowInfrastructureBeans();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    SpringBeansView.this.getSettings().setShowInfrastructureBeans(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_LIST);
                }
            });
        }
        DefaultActionGroup defaultActionGroup = this.myConfigurationViewActionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/SpringBeansView", "getConfigurationViewActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public DefaultActionGroup getPresentationActionGroup() {
        if (this.myPresentationActionGroup == null) {
            this.myPresentationActionGroup = new DefaultActionGroup();
            this.myPresentationActionGroup.add((AnAction)new ToggleAction("Show Bean Documentation", null, AllIcons.Toolwindows.Documentation){

                public boolean isSelected(AnActionEvent e) {
                    return SpringBeansView.this.getSettings().isShowDoc();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    SpringBeansView.this.getSettings().setShowDoc(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_DETAILS);
                }
            });
            if (((SpringBeanPointerFinderRecursivePanel.SpringBeanPointerPanelContent[])SpringBeanPointerFinderRecursivePanel.EP_NAME.getExtensions()).length != 0) {
                this.myPresentationActionGroup.add((AnAction)new ToggleAction("Show Bean Graph", null, AllIcons.FileTypes.Diagram){

                    public boolean isSelected(AnActionEvent e) {
                        return SpringBeansView.this.getSettings().isShowGraph();
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        SpringBeansView.this.getSettings().setShowGraph(state);
                        SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_DETAILS);
                    }
                });
            }
        }
        DefaultActionGroup defaultActionGroup = this.myPresentationActionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/SpringBeansView", "getPresentationActionGroup"));
        }
        return defaultActionGroup;
    }
}

