/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.SpringModulesPanelBase;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringFileSetFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import gnu.trove.THashSet;
import icons.SpringApiIcons;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeansModulesPanel
extends SpringModulesPanelBase {
    private final DefaultActionGroup myStructureViewActionGroup;
    private ToggleAction myShowFilesetAction;

    public SpringBeansModulesPanel(@NotNull Project project, @NotNull DefaultActionGroup structureViewActionGroup) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel", "<init>"));
        }
        if (structureViewActionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureViewActionGroup", "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel", "<init>"));
        }
        super(project, "SpringBeansModulesPanel");
        this.myStructureViewActionGroup = structureViewActionGroup;
        this.installActions();
    }

    private void installActions() {
        this.myShowFilesetAction = new ToggleAction("Show filesets", null, SpringApiIcons.FileSet){

            public boolean isSelected(AnActionEvent e) {
                return SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).isShowFileSets();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).isShowModules());
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).setShowFileSets(state);
                SpringBeansModulesPanel.this.updateRightComponent(true);
            }
        };
        this.myStructureViewActionGroup.add((AnAction)this.myShowFilesetAction);
    }

    public void dispose() {
        this.myStructureViewActionGroup.remove((AnAction)this.myShowFilesetAction);
        super.dispose();
    }

    @Nullable
    protected JComponent createRightComponent(final Module module) {
        if (SpringBeansViewSettings.getInstance(this.getProject()).isShowFileSets()) {
            return new SpringFileSetFinderRecursivePanel(this, module, this.myStructureViewActionGroup);
        }
        NullableFactory<CommonSpringModel> factory = new NullableFactory<CommonSpringModel>(){

            public CommonSpringModel create() {
                return new BeansSpringModel(null, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        THashSet allBeans = new THashSet();
                        for (SpringModel model : SpringManager.getInstance((Project)SpringBeansModulesPanel.this.getProject()).getAllModelsWithoutDependencies(module)) {
                            allBeans.addAll(model.getAllCommonBeans());
                        }
                        THashSet tHashSet = allBeans;
                        if (tHashSet == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel$2$1", "compute"));
                        }
                        return tHashSet;
                    }
                });
            }
        };
        return new SpringBeanPointerFinderRecursivePanel((FinderRecursivePanel)this, factory);
    }
}

