/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.facet.Facet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringBeansModulesPanel;
import com.intellij.spring.toolWindow.panels.SpringConfigFilesFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFileSetFinderRecursivePanel
extends FinderRecursivePanel<SpringFileSet> {
    private static final Condition<SpringFileSet> FILESET_NOT_REMOVED_CONDITION = new Condition<SpringFileSet>(){

        public boolean value(SpringFileSet set) {
            return !set.isRemoved();
        }
    };
    private final Module myModule;
    @NotNull
    private final DefaultActionGroup myStructureViewActionGroup;
    private ToggleAction myShowConfigurationAction;

    public SpringFileSetFinderRecursivePanel(@NotNull SpringBeansModulesPanel panel, @NotNull Module module, @NotNull DefaultActionGroup structureViewActionGroup) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel", "<init>"));
        }
        if (structureViewActionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureViewActionGroup", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel", "<init>"));
        }
        super((FinderRecursivePanel)panel);
        this.myModule = module;
        this.myStructureViewActionGroup = structureViewActionGroup;
        this.myShowConfigurationAction = new ToggleAction("Show configuration files", null, SpringApiIcons.SpringConfig){

            public boolean isSelected(AnActionEvent e) {
                return SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowFiles();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowModules() && SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowFileSets());
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).setShowFiles(state);
                SpringFileSetFinderRecursivePanel.this.updateRightComponent(true);
            }
        };
        this.myStructureViewActionGroup.add((AnAction)this.myShowConfigurationAction);
    }

    @NotNull
    protected List<SpringFileSet> getListItems() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.myModule);
        assert (springFacet != null) : this.myModule;
        Set fileSets = SpringFileSetService.getInstance().getAllSets(springFacet);
        List list = ContainerUtil.filter((Collection)fileSets, FILESET_NOT_REMOVED_CONDITION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel", "getListItems"));
        }
        return list;
    }

    public void dispose() {
        this.myStructureViewActionGroup.remove((AnAction)this.myShowConfigurationAction);
        super.dispose();
    }

    protected String getListEmptyText() {
        return "No filesets defined";
    }

    @NotNull
    protected String getItemText(SpringFileSet fileSet) {
        String string = fileSet.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringFileSet fileSet) {
        return fileSet.getIcon();
    }

    protected boolean performEditAction() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.myModule);
        if (springFacet != null) {
            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
        }
        return true;
    }

    @Nullable
    protected JComponent createRightComponent(final SpringFileSet fileSet) {
        if (SpringBeansViewSettings.getInstance(this.getProject()).isShowFiles()) {
            return new SpringConfigFilesFinderRecursivePanel(this, fileSet, this.myModule);
        }
        NullableFactory<CommonSpringModel> factory = new NullableFactory<CommonSpringModel>(){

            public CommonSpringModel create() {
                return SpringCombinedModelFactory.createModel(fileSet, SpringFileSetFinderRecursivePanel.this.myModule);
            }
        };
        return new SpringBeanPointerFinderRecursivePanel(this, factory);
    }

    protected boolean hasChildren(SpringFileSet fileSet) {
        return !fileSet.getFiles().isEmpty();
    }
}

