/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.path;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.web.CustomServletReferenceAdapter;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.ActionMappings;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import icons.StrutsApiIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionWebPathsProvider
extends CustomServletReferenceAdapter {
    private final boolean myPrefixAllowed;

    public ActionWebPathsProvider() {
        this.myPrefixAllowed = true;
    }

    public ActionWebPathsProvider(boolean prefixAllowed) {
        this.myPrefixAllowed = prefixAllowed;
    }

    @Nullable
    public PathReference createWebPath(String path, @NotNull PsiElement element, ServletMappingInfo info) {
        Action action;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider", "createWebPath"));
        }
        StrutsModel model = StrutsManager.getInstance().getStrutsModel(element);
        if (model != null && (action = model.resolveActionURL(path)) != null) {
            return new PathReference(path, (Function)new ConstantFunction((Object)StrutsApiIcons.ActionMapping)){

                public PsiElement resolve() {
                    return action.getXmlTag();
                }
            };
        }
        return null;
    }

    protected PsiReference[] createReferences(@NotNull PsiElement element, int offset, String text, @Nullable ServletMappingInfo info, boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider", "createReferences"));
        }
        StrutsModel model = StrutsManager.getInstance().getStrutsModel(element);
        if (model != null) {
            return new PsiReference[]{new ActionReference(element, offset, text, (ServletMappingInfo)(info == null || info.equals((Object)model.getServletMappingInfo()) ? info : null), soft)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private class ActionReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public ActionReference(PsiElement element, int offset, String text, ServletMappingInfo info, boolean soft) {
            TextRange range;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference", "<init>"));
            }
            super(element, new TextRange(offset, offset + text.length()), soft);
            if (info != null && (info.getType() != ServletMappingType.PATH || ActionWebPathsProvider.this.myPrefixAllowed) && (range = info.getNameRange(text)) != null) {
                this.setRangeInElement(range.shiftRight(offset));
            }
        }

        @Nullable
        public PsiElement resolve() {
            Action action;
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                return null;
            }
            String url = this.getValue();
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            if ((action = model.findAction(url)) != null) {
                return action.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            final ServletMappingInfo info = model.getServletMappingInfo();
            List actions = model.getActions();
            Object[] objectArray = ElementPresentationManager.getInstance().createVariants((Collection)actions, (Function)new Function<Action, String>(){

                @Nullable
                public String fun(Action action) {
                    String actionPath = (String)action.getPath().getValue();
                    if (actionPath == null) {
                        return null;
                    }
                    return ActionWebPathsProvider.this.myPrefixAllowed ? info.addMapping(actionPath) : actionPath;
                }
            }, 1);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = StrutsBundle.message((String)"cannot.resolve.action", (Object[])new Object[]{this.getValue()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }

        @Nullable
        private ResolvingElementQuickFix createFix() {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                return null;
            }
            String text = this.getValue();
            ActionMappings scope = ((StrutsConfig)model.getMergedModel()).getActionMappings();
            return ResolvingElementQuickFix.createFix((String)text, Action.class, (DomElement)scope);
        }

        public LocalQuickFix[] getQuickFixes() {
            LocalQuickFix[] localQuickFixArray;
            ResolvingElementQuickFix quickFix = this.createFix();
            if (quickFix == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = quickFix;
            }
            return localQuickFixArray;
        }
    }
}

