/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.psi;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.NamedModelImpl;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.validator.FormValidation;
import com.intellij.struts.dom.validator.Global;
import com.intellij.struts.dom.validator.Validator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationModelImpl
extends NamedModelImpl<FormValidation>
implements ValidationModel {
    private final StrutsModel myStrutsModel;

    public ValidationModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<FormValidation> model, @NotNull StrutsModel strutsModel) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/struts/psi/ValidationModelImpl", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/struts/psi/ValidationModelImpl", "<init>"));
        }
        if (strutsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strutsModel", "com/intellij/struts/psi/ValidationModelImpl", "<init>"));
        }
        super(configFiles, model, strutsModel.getName());
        this.myStrutsModel = strutsModel;
    }

    @NotNull
    public List<Validator> getValidators() {
        List globals = ((FormValidation)this.getMergedModel()).getGlobals();
        ArrayList<Validator> result = new ArrayList<Validator>();
        for (Global global : globals) {
            List validators = global.getValidators();
            List filteredValidators = ContainerUtil.findAll((Collection)validators, (Condition)new Condition<Validator>(){

                public boolean value(Validator validator) {
                    return StringUtil.isNotEmpty((String)validator.getClassname().getStringValue());
                }
            });
            result.addAll(filteredValidators);
        }
        ArrayList<Validator> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/ValidationModelImpl", "getValidators"));
        }
        return arrayList;
    }

    @Nullable
    public Validator findValidator(String name) {
        return (Validator)DomUtil.findByName(this.getValidators(), (String)name);
    }

    @NotNull
    public StrutsModel getStrutsModel() {
        StrutsModel strutsModel = this.myStrutsModel;
        if (strutsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/ValidationModelImpl", "getStrutsModel"));
        }
        return strutsModel;
    }
}

