/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.struts.tree.StrutsTreeBase;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.tree.DomFileElementNode;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

public class DomBrowser
implements Disposable {
    private final JScrollPane myScrollPane;
    private final StrutsTreeBase myTreeView;

    public DomBrowser(StrutsTreeBase tree) {
        this.myTreeView = tree;
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeView));
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
    }

    public SimpleTree getTree() {
        return this.myTreeView.getTree();
    }

    @NotNull
    public JComponent getComponent() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/tree/DomBrowser", "getComponent"));
        }
        return jScrollPane;
    }

    public void setSelectedDomElement(DomElement element) {
        this.myTreeView.setSelectedDomElement(element);
    }

    public boolean hasFile(PsiFile file) {
        TreeModel treeModel = this.getTree().getModel();
        Object root = treeModel.getRoot();
        if (root == null) {
            return false;
        }
        for (int i = 0; i < treeModel.getChildCount(root); ++i) {
            Object el = ((DefaultMutableTreeNode)treeModel.getChild(root, i)).getUserObject();
            if (!(el instanceof DomFileElementNode) || ((DomFileElementNode)el).getDomElement().getFile() != file) continue;
            return true;
        }
        return false;
    }

    public void openDefault() {
        this.myTreeView.init();
    }

    public void update() {
        this.myTreeView.getBuilder().updateFromRoot();
    }

    public void dispose() {
    }
}

