/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ws.rest.client.RESTClient;
import com.intellij.ws.rest.client.RestClientBundle;
import icons.RestClientIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class CreateRestClientAction
extends DumbAwareAction {
    @NonNls
    public static final String REST_CLIENT = RestClientBundle.message("reference.tool.windows.rest.client", new Object[0]);

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        CreateRestClientAction.openRestClient(project);
    }

    public static RESTClient openRestClient(Project project) {
        Content content;
        RESTClient form;
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindow w = manager.getToolWindow(REST_CLIENT);
        if (w == null) {
            form = new RESTClient(project);
            w = manager.registerToolWindow(REST_CLIENT, true, ToolWindowAnchor.BOTTOM, (Disposable)form, true);
            content = w.getContentManager().getFactory().createContent(form.getComponent(), "", false);
            content.setDisposer((Disposable)form);
            content.setCloseable(false);
            w.getContentManager().addContent(content);
            w.setIcon(RestClientIcons.Rest_client_icon_small);
        } else {
            content = w.getContentManager().getContent(0);
            form = (RESTClient)content.getDisposer();
        }
        final ToolWindowImpl window = (ToolWindowImpl)w;
        w.show(new Runnable(){

            @Override
            public void run() {
                JComponent component = window.getComponent();
                int delta = component.getMinimumSize().height - component.getSize().height;
                if (delta > 0) {
                    window.stretchHeight(delta);
                }
            }
        });
        w.activate(null);
        return form;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }
}

