/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.ws.rest.client.RESTClient;
import java.io.IOException;
import java.util.Collection;

public class RestClientFileUtil {
    private static final Logger LOG = Logger.getInstance(RESTClient.class);
    private static final String REST_CLIENT_ROOT = "dummy://restClient";
    private static int ourRequestCounter = 0;

    static FileType findFileType(String mimeType) {
        PlainTextFileType fileType = PlainTextFileType.INSTANCE;
        Collection languages = Language.findInstancesByMimeType((String)mimeType);
        for (Language language : languages) {
            LanguageFileType langFileType = language.getAssociatedFileType();
            if (langFileType == null) continue;
            fileType = langFileType;
            break;
        }
        return fileType;
    }

    public static VirtualFile createFile(final String response, final FileType fileType) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile result = null;
                VirtualFile dummyRoot = RestClientFileUtil.getOrCreateDummyRoot();
                try {
                    result = DummyFileSystem.getInstance().createChildFile(null, dummyRoot, RestClientFileUtil.generateFilename(fileType));
                    VfsUtil.saveText((VirtualFile)result, (String)response);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                return result;
            }
        });
    }

    static void deleteFile(final VirtualFile file) {
        if (file == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    DummyFileSystem.getInstance().deleteFile(null, file);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    private static String generateFilename(FileType fileType) {
        return "response" + ourRequestCounter++ + "." + fileType.getDefaultExtension();
    }

    private static VirtualFile getOrCreateDummyRoot() {
        VirtualFile dummyRoot = VirtualFileManager.getInstance().refreshAndFindFileByUrl(REST_CLIENT_ROOT);
        if (dummyRoot == null) {
            dummyRoot = DummyFileSystem.getInstance().createRoot("restClient");
        }
        return dummyRoot;
    }
}

