/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.intellij.ws.rest.client.HttpHeadersDictionary;
import com.intellij.ws.rest.client.NameValueTableModel;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;

public class RestClientRequestPanel
extends JPanel {
    private final Project myProject;
    private final ToggleSendParamsAction myToggleSendParamsAction;
    private JPanel myMainPanel;
    private boolean myDoNotSendParams;
    private JPanel myParametersPanel;
    private TextFieldWithBrowseButton myFile;
    private JLabel myFileLabel;
    private JBRadioButton myRbEmpty;
    private JBRadioButton myRbFileContents;
    private JBRadioButton myRbFileUpload;
    private JBRadioButton myRbText;
    private TextFieldWithBrowseButton myTextToSend;
    private JPanel myHeaderPanel;
    private JPanel myRequestBodyPanel;
    private final NameValueTableModel myHeaderData;
    private final NameValueTableModel myRequestData;
    private JBListTable myHeaderTable;
    private JBListTable myRequestTable;
    @NonNls
    public static final String ACCEPT = "Accept";
    @NonNls
    public static final String CONTENT_TYPE = "Content-Type";
    @NonNls
    public static final String CONTENT_LENGTH = "Content-Length";
    @NonNls
    public static final String CACHE_CONTROL = "Cache-Control";
    @NonNls
    public static final String[] IMMUTABLE_HEADER_PARAMS = new String[]{"Accept", "Content-Length", "Cache-Control"};
    private String[] myMimeTypes;

    public RestClientRequestPanel(final Project project, Disposable parent) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myHeaderData = new NameValueTableModel();
        this.myRequestData = new NameValueTableModel();
        this.myProject = project;
        this.add((Component)this.myMainPanel, "Center");
        this.myFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true);
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
                if (files.length > 0) {
                    ArrayList<String> paths = new ArrayList<String>();
                    for (VirtualFile file : files) {
                        paths.add(file.getPath());
                    }
                    RestClientRequestPanel.this.myFile.setText(StringUtil.join(paths, (String)File.pathSeparator));
                } else {
                    RestClientRequestPanel.this.myFile.setText("");
                }
            }
        });
        this.myTextToSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList list = new ArrayList();
                RestClientRequestPanel.collectKeyValuePairs(RestClientRequestPanel.this.myHeaderData, list);
                String mimeType = "";
                for (RestClientRequest.KeyValuePair pair : list) {
                    if (!RestClientRequestPanel.CONTENT_TYPE.equals(pair.getKey())) continue;
                    mimeType = pair.getValue();
                    break;
                }
                VirtualFile file = RestClientFileUtil.createFile(RestClientRequestPanel.this.myTextToSend.getText(), RestClientFileUtil.findFileType(mimeType));
                final Document document = FileDocumentManager.getInstance().getDocument(file);
                assert (document != null) : "Failed to get document for " + mimeType;
                Editor editor = EditorFactory.getInstance().createEditor(document, RestClientRequestPanel.this.myProject, file, false);
                final DialogBuilder builder = new DialogBuilder(RestClientRequestPanel.this.myProject);
                builder.setDimensionServiceKey("RestClientTextRequest");
                builder.setTitle("Specify the text to send:");
                editor.getComponent().setPreferredSize(new Dimension(400, 300));
                builder.setCenterPanel(editor.getComponent());
                builder.setPreferredFocusComponent(editor.getContentComponent());
                builder.addOkAction();
                builder.setOkOperation(new Runnable(){

                    @Override
                    public void run() {
                        RestClientRequestPanel.this.myTextToSend.setText(document.getText());
                        builder.getDialogWrapper().close(0);
                    }
                });
                builder.addCancelAction();
                builder.show();
                RestClientFileUtil.deleteFile(file);
                EditorFactory.getInstance().releaseEditor(editor);
            }
        });
        this.myTextToSend.setButtonIcon(AllIcons.Actions.ShowViewer);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RestClientRequestPanel.this.updateFileEnabled();
            }
        };
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myMainPanel);
        ((Splitter)this.myMainPanel.getComponent(0)).setProportion(0.33333334f);
        ((Splitter)((Splitter)this.myMainPanel.getComponent(0)).getComponent(2)).setProportion(0.5f);
        this.myRbEmpty.addActionListener(listener);
        this.myRbText.addActionListener(listener);
        this.myRbFileContents.addActionListener(listener);
        this.myRbFileUpload.addActionListener(listener);
        this.myMimeTypes = RestClientRequestPanel.collectMimeTypes(project);
        Insets insets = new Insets(0, 0, 5, 3);
        this.myHeaderPanel.setBorder((Border)new IdeaTitledBorder("  Headers", 5, insets));
        JBTable headerParameters = new JBTable((TableModel)this.myHeaderData);
        this.myHeaderTable = new NameValueListTable(project, headerParameters, ": ", HttpHeadersDictionary.getHeaders(), parent);
        JPanel panel = ToolbarDecorator.createDecorator((JTable)this.myHeaderTable.getTable()).disableUpDownActions().createPanel();
        this.myHeaderPanel.add((Component)panel, "Center");
        this.myHeaderData.setImmutableFields(IMMUTABLE_HEADER_PARAMS);
        this.myHeaderData.setImmutableHeaderExceptions(ACCEPT, CACHE_CONTROL);
        this.setHeader(ACCEPT, "*/*");
        this.setHeader(CACHE_CONTROL, "no-cache");
        this.myParametersPanel.setBorder((Border)new IdeaTitledBorder(" Request Parameters", 2, insets));
        JBTable parameters = new JBTable((TableModel)this.myRequestData);
        parameters.setModel((TableModel)this.myRequestData);
        this.myRequestTable = new NameValueListTable(project, parameters, "=", null, parent);
        this.myToggleSendParamsAction = new ToggleSendParamsAction();
        JPanel requestPanel = ToolbarDecorator.createDecorator((JTable)this.myRequestTable.getTable()).disableUpDownActions().addExtraAction((AnActionButton)this.myToggleSendParamsAction).createPanel();
        this.myParametersPanel.add((Component)requestPanel, "Center");
        this.myRequestBodyPanel.setBorder((Border)new IdeaTitledBorder("Request Body", 0, insets));
    }

    public void setCanHasBody(boolean canHasBody) {
        if (!canHasBody) {
            this.myRbEmpty.setSelected(true);
        }
        this.myRbEmpty.setEnabled(canHasBody);
        this.myRbText.setEnabled(canHasBody);
        this.myRbFileContents.setEnabled(canHasBody);
        this.myRbFileUpload.setEnabled(canHasBody);
    }

    void updateFileEnabled() {
        boolean canHasFile = this.myRbFileUpload.isSelected() || this.myRbFileContents.isSelected();
        this.myFile.setEnabled(canHasFile);
        this.myFileLabel.setEnabled(canHasFile);
        this.myTextToSend.setEnabled(this.myRbText.isSelected());
    }

    public void updateHeaderEditor() {
        this.myMimeTypes = RestClientRequestPanel.collectMimeTypes(this.myProject);
    }

    public void saveToRequest(RestClientRequest request) {
        RestClientRequestPanel.collectKeyValuePairs(this.myHeaderData, request.headers);
        RestClientRequestPanel.collectKeyValuePairs(this.myRequestData, request.parameters);
        request.parametersEnabled = !this.myDoNotSendParams;
        request.haveTextToSend = this.myRbText.isSelected();
        request.haveFileToSend = this.myRbFileContents.isSelected() || this.myRbFileUpload.isSelected();
        request.isFileUpload = this.myRbFileUpload.isSelected();
        request.textToSend = this.myTextToSend.getText();
        request.filesToSend = this.myFile.getText();
    }

    public void loadFromRequest(RestClientRequest request) {
        this.stopEditing();
        RestClientRequestPanel.applyKeyValuePairs(this.myHeaderData, request.headers, this.myHeaderTable);
        RestClientRequestPanel.applyKeyValuePairs(this.myRequestData, request.parameters, this.myRequestTable);
        this.setDoNotSendParams(!request.parametersEnabled);
        if (request.haveTextToSend) {
            this.myRbText.setSelected(true);
            this.myTextToSend.setText(request.textToSend);
        } else if (request.haveFileToSend) {
            this.myFile.setText(request.filesToSend);
            if (request.isFileUpload) {
                this.myRbFileUpload.setSelected(true);
            } else {
                this.myRbFileContents.setSelected(true);
            }
        } else {
            this.myRbEmpty.setSelected(true);
        }
    }

    private void setDoNotSendParams(boolean enabled) {
        this.myDoNotSendParams = enabled;
        this.myRequestTable.getTable().setEnabled(!this.myDoNotSendParams);
        this.myToggleSendParamsAction.setEnabled(true);
    }

    private static void collectKeyValuePairs(NameValueTableModel data, List<RestClientRequest.KeyValuePair> keyValuePairs) {
        for (int i = 0; i < data.getElementsCount(); ++i) {
            keyValuePairs.add(new RestClientRequest.KeyValuePair(data.getName(i), data.getValue(i)));
        }
    }

    private static void applyKeyValuePairs(NameValueTableModel data, List<RestClientRequest.KeyValuePair> keyValuePairs, JBListTable table) {
        data.clear();
        for (RestClientRequest.KeyValuePair header : keyValuePairs) {
            data.addPropertyRow(header.getKey(), header.getValue());
        }
        ((AbstractTableModel)table.getTable().getModel()).fireTableDataChanged();
    }

    public void setHeader(String name, String value) {
        this.myHeaderData.addProperty(name, value);
        ((AbstractTableModel)this.myHeaderTable.getTable().getModel()).fireTableDataChanged();
    }

    public void addRequestParameter(String name, String value) {
        this.myRequestData.addPropertyRow(name, value);
        ((AbstractTableModel)this.myRequestTable.getTable().getModel()).fireTableDataChanged();
    }

    private static String[] collectMimeTypes(Project project) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, "*/*", "text/plain", "text/html", "application/xml", "application/json", "application/atom+xml");
        for (RestClientDataProvider provider : (RestClientDataProvider[])Extensions.getExtensions(RestClientDataProvider.EP_NAME)) {
            Collections.addAll(result, provider.getAllMimeTypes(project));
        }
        return ArrayUtil.toStringArray(result);
    }

    public void stopEditing() {
        this.myHeaderTable.stopEditing();
        this.myRequestTable.stopEditing();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JSplitPane jSplitPane2 = new JSplitPane();
        jSplitPane.setRightComponent(jSplitPane2);
        this.myRequestBodyPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jSplitPane2.setRightComponent(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, new Dimension(-1, 30), new Dimension(-1, 30), new Dimension(-1, 30)));
        this.myFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myFileLabel = jLabel = new JLabel();
        jLabel.setText("File to send:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myRbEmpty = jBRadioButton4 = new JBRadioButton();
        jBRadioButton4.setText("Empty");
        jBRadioButton4.setSelected(true);
        jPanel3.add((Component)jBRadioButton4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRbFileContents = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("File contents");
        jPanel3.add((Component)jBRadioButton3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRbFileUpload = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("File upload (multipart/form-data)");
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRbText = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Text:");
        jPanel3.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextToSend = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myParametersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jSplitPane2.setLeftComponent(jPanel2);
        this.myHeaderPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jSplitPane.setLeftComponent(jPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ToggleSendParamsAction
    extends ToggleActionButton {
        public ToggleSendParamsAction() {
            super("Do not send parameters", AllIcons.Actions.Clean);
        }

        public boolean isSelected(AnActionEvent e) {
            return RestClientRequestPanel.this.myDoNotSendParams;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            RestClientRequestPanel.this.setDoNotSendParams(state);
        }
    }

    private class NameValueListTable
    extends JBListTable {
        private final Project myProject;
        private final String myNameValueSeparator;
        private final Collection<String> myNames;
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        public NameValueListTable(Project project, JBTable baseTable, String nameValueSeparator, Collection<String> names, Disposable parent) {
            super((JTable)baseTable, parent);
            this.myProject = project;
            this.myNameValueSeparator = nameValueSeparator;
            this.myNames = names;
            this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(this.myProject, null, parent){

                protected String getText(JTable table, int row) {
                    String headerName = (String)NameValueListTable.this.myInternalTable.getValueAt(row, 0);
                    String headerValue = (String)NameValueListTable.this.myInternalTable.getValueAt(row, 1);
                    int index = headerValue.indexOf("\n");
                    if (index >= 0) {
                        headerValue = headerValue.substring(0, index) + "...";
                    }
                    return " " + headerName + NameValueListTable.this.myNameValueSeparator + headerValue;
                }
            };
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected JBTableRowEditor getRowEditor(final int row) {
            return new JBTableRowEditor(){
                private EditorTextField myNameEditor;
                private EditorComboBox myValueEditor;

                public void prepareEditor(JTable table, int row2) {
                    String headerName = row2 < NameValueListTable.this.myInternalTable.getRowCount() ? (String)NameValueListTable.this.myInternalTable.getValueAt(row2, 0) : "";
                    String headerValue = row2 < NameValueListTable.this.myInternalTable.getRowCount() ? (String)NameValueListTable.this.myInternalTable.getValueAt(row2, 1) : "";
                    this.setLayout(new GridLayout(1, 2));
                    this.myNameEditor = new TextFieldWithAutoCompletion(NameValueListTable.this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(NameValueListTable.this.myNames, null), NameValueListTable.this.myNames != null, headerName);
                    this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                    this.add(2.createLabeledPanel((String)"Name:", (JComponent)this.myNameEditor));
                    this.myValueEditor = new EditorComboBox(headerValue){

                        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                            if (e.getID() == 401 && e.getKeyCode() == 10) {
                                NameValueListTable.this.stopEditing();
                                e.consume();
                                return true;
                            }
                            return super.processKeyBinding(ks, e, condition, pressed);
                        }
                    };
                    if (headerName.equals(RestClientRequestPanel.ACCEPT)) {
                        this.myValueEditor.setHistory(RestClientRequestPanel.this.myMimeTypes);
                    }
                    this.myValueEditor.prependItem(headerValue);
                    this.myValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
                    this.add(2.createLabeledPanel((String)"Value:", (JComponent)this.myValueEditor));
                }

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            switch (column) {
                                case 0: {
                                    return myNameEditor.getText().trim();
                                }
                                case 1: {
                                    return myValueEditor.getText().trim();
                                }
                            }
                            return null;
                        }
                    };
                }

                public JComponent getPreferredFocusedComponent() {
                    String headerName = row >= NameValueListTable.this.myInternalTable.getRowCount() ? null : (String)NameValueListTable.this.myInternalTable.getValueAt(row, 0);
                    return StringUtil.isEmpty(headerName) ? this.myNameEditor.getFocusTarget() : this.myValueEditor;
                }

                public JComponent[] getFocusableComponents() {
                    return new JComponent[]{this.myNameEditor.getFocusTarget(), this.myValueEditor};
                }
            };
        }
    }
}

