/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.spring.model.converters.PackageListConverter;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.converters.resources.ResourceValueConverter;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringPersistenceConverters {
    private static Condition<Pair<PsiType, GenericDomValue>> createBeanPropertyCondition(final String propertyName, boolean annotationsOnly) {
        return new Condition<Pair<PsiType, GenericDomValue>>(){

            public boolean value(Pair<PsiType, GenericDomValue> pair) {
                GenericDomValue domValue = (GenericDomValue)pair.getSecond();
                SpringProperty property = (SpringProperty)domValue.getParentOfType(SpringProperty.class, true);
                return property != null && propertyName.equals(property.getName().getStringValue());
            }
        };
    }

    public static class AnnotatedPackagesConverter
    extends ResourceValueConverter
    implements GenericDomValueConvertersRegistry.Provider {
        @NotNull
        public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
            SmartList result = new SmartList();
            int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
            SpringReferenceUtils.processSeparatedString((String)genericDomValue.getStringValue(), (String)",", (PairProcessor)new PairProcessor<String, Integer>((List)result, element, startInElement){
                final /* synthetic */ List val$result;
                final /* synthetic */ PsiElement val$element;
                final /* synthetic */ int val$startInElement;
                {
                    this.val$result = list;
                    this.val$element = psiElement;
                    this.val$startInElement = n;
                }

                public boolean process(String s, Integer offset) {
                    this.val$result.addAll(new PackageReferenceSet(s, this.val$element, offset + this.val$startInElement).getReferences());
                    return true;
                }
            });
            PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringPersistenceConverters$AnnotatedPackagesConverter", "createReferences"));
            }
            return psiReferenceArray;
        }

        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("annotatedPackages", true);
        }
    }

    public static class MappingResourcesConverter
    extends ResourceValueConverter
    implements GenericDomValueConvertersRegistry.Provider {
        @NotNull
        public PsiReference[] createReferences(GenericDomValue genericDomValue, final PsiElement element, ConvertContext context) {
            SmartList result = new SmartList();
            final int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
            SpringReferenceUtils.processSeparatedString((String)genericDomValue.getStringValue(), (String)",", (PairProcessor)new PairProcessor<String, Integer>((List)result){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public boolean process(String s, Integer offset) {
                    Object[] references = SpringResourcesUtil.getInstance().getClassPathReferences(SpringResourcesBuilder.create((PsiElement)element, (String)s).offset(offset + startInElement));
                    ContainerUtil.addAll((Collection)this.val$result, (Object[])references);
                    return true;
                }
            });
            PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringPersistenceConverters$MappingResourcesConverter", "createReferences"));
            }
            return psiReferenceArray;
        }

        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("mappingResources", false);
        }
    }

    public static class MyPackageConverter
    extends PackageListConverter
    implements GenericDomValueConvertersRegistry.Provider {
        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("packagesToScan", true);
        }

        protected String getDelimiters() {
            return ",";
        }
    }
}

