/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.diagram.SpringIntegrationBeanPointerWrapper;
import com.intellij.spring.integration.diagram.SpringIntegrationDiagramProvider;
import com.intellij.spring.integration.diagram.SpringIntegrationNode;
import com.intellij.spring.integration.model.xml.core.EndpointDomBean;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.edges.MessageFlowEdge;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import icons.SpringIntegrationIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private static final HashSet<String> INBOUND_CHANNELS = new HashSet<String>(Arrays.asList("input-channel", "default-reply-channel", "reply-channel"));
    private static final HashSet<String> OUTBOUND_CHANNELS = new HashSet<String>(Arrays.asList("default-output-channel", "output-channel", "default-request-channel", "request-channel", "default-publisher-channel", "default-channel"));
    private static final HashSet<String> NON_STANDARD_OUTBOUND_CHANNELS = new HashSet<String>(Arrays.asList("error-channel", "discard-channel", "return-channel", "on-success-result-channel", "on-failure-result-channel", "confirm-ack-channel", "confirm-nack-channel"));
    private static final String CHANNEL = "channel";
    private static final HashSet<String> ROUTER_OUTBOUND_CHANNEL_PARENTS = new HashSet<String>(Arrays.asList("mapping", "recipient"));
    private static final String OUTBOUND_GATEWAY_INBOUND = "request-channel";
    private static final String OUTBOUND_GATEWAY_OUTBOUND = "reply-channel";
    private final SpringElementWrapper myElement;
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = new HashSet<DiagramNode<SpringElementWrapper>>();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = new HashSet<DiagramEdge<SpringElementWrapper>>();
    private final Collection<SpringBeanPointer> messageChannels = new HashSet<SpringBeanPointer>();

    public SpringIntegrationDataModel(Project project, SpringIntegrationDiagramProvider provider, SpringElementWrapper element) {
        super(project, (DiagramProvider)provider);
        this.myElement = element;
    }

    @NotNull
    public Collection<? extends DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "getNodeName"));
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper element) {
        SpringIntegrationNode node = new SpringIntegrationNode(element, (DiagramProvider<SpringElementWrapper>)this.getProvider());
        this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        return node;
    }

    public void refreshDataModel() {
        this.myEdges.clear();
        this.myNodes.clear();
        Module module = this.myElement.getModule();
        if (module == null || DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        CommonSpringModel myApplicationModel = this.myElement.getProcessingSpringModel(false);
        if (myApplicationModel == null) {
            return;
        }
        this.messageChannels.clear();
        this.messageChannels.addAll(SpringIntegrationUtil.getMessageChannels(module));
        for (SpringBeanPointer pointer : myApplicationModel.getAllDomBeans()) {
            DiagramNode<SpringElementWrapper> sourceNode;
            if (!SpringIntegrationDataModel.isIntegrationBeanPointer(pointer) || (sourceNode = this.getOrCreateElement(pointer)) == null) continue;
            this.processDependencies(pointer, sourceNode);
        }
    }

    private static boolean isIntegrationBeanPointer(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "isIntegrationBeanPointer"));
        }
        return pointer.getSpringBean() instanceof EndpointDomBean;
    }

    protected void processDependencies(@NotNull SpringBeanPointer pointer, @NotNull DiagramNode<SpringElementWrapper> node) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "processDependencies"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "processDependencies"));
        }
        if (this.isProcessed(node)) {
            return;
        }
        SpringIntegrationDataModel.setProcessed(node);
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof EndpointDomBean) {
            this.addPointedDependencies(node, springBean);
        }
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper> sourceNode, CommonSpringBean springBean) {
        if (SpringIntegrationDataModel.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer messageChannelPointer;
                        DiagramNode<SpringElementWrapper> target;
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer && SpringIntegrationDataModel.this.messageChannels.contains(pointer) && (target = SpringIntegrationDataModel.this.getOrCreateElement(messageChannelPointer = (SpringBeanPointer)pointer)) != null) {
                            SpringIntegrationDataModel.this.addEdge((DiagramEdge<SpringElementWrapper>)SpringIntegrationDataModel.createIntegrationEdge((DiagramNode<SpringElementWrapper>)sourceNode, (DiagramNode<SpringElementWrapper>)target, (GenericAttributeValue)element));
                        }
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramEdge<SpringElementWrapper> edge) {
        if (edge == null) {
            return;
        }
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add(edge);
        }
    }

    private static DiagramEdge<SpringElementWrapper> createIntegrationEdge(DiagramNode<SpringElementWrapper> sourceNode, DiagramNode<SpringElementWrapper> targetNode, GenericAttributeValue identifyingAttributeValue) {
        XmlAttribute xmlAttribute = identifyingAttributeValue.getXmlAttribute();
        if (xmlAttribute == null) {
            return null;
        }
        String attributeName = xmlAttribute.getName();
        if (SpringIntegrationDataModel.isInboundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(targetNode, sourceNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isOutBoundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isNonStandardOutBoundChannel(attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName);
        }
        return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName, true);
    }

    private static boolean isNonStandardOutBoundChannel(String attributeName) {
        return NON_STANDARD_OUTBOUND_CHANNELS.contains(attributeName);
    }

    private static boolean isOutBoundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return false;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return true;
            }
        }
        boolean inboundAdapter = SpringIntegrationIcons.Diagram.InboundAdapter.equals(parent.getPresentation().getIcon());
        boolean outboundRouter = ROUTER_OUTBOUND_CHANNEL_PARENTS.contains(parent.getXmlElementName());
        return OUTBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && (outboundRouter || inboundAdapter);
    }

    private static boolean isInboundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return true;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return false;
            }
        }
        boolean outboundAdapter = SpringIntegrationIcons.Diagram.OutboundAdapter.equals(parent.getPresentation().getIcon());
        return INBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && outboundAdapter;
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "setProcessed"));
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "isProcessed"));
        }
        Boolean isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY);
        return isProcessed != null && isProcessed != false;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> getOrCreateElement(SpringBeanPointer beanPointer) {
        DiagramNode<SpringElementWrapper> target = this.getNode(beanPointer);
        if (target == null) {
            target = this.addNode(beanPointer);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull SpringBeanPointer bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "getNode"));
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addNode(SpringBeanPointer element) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringIntegrationBeanPointerWrapper.create(element));
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper beanPointerWrapper) {
        SpringIntegrationNode node = new SpringIntegrationNode(beanPointerWrapper, (DiagramProvider<SpringElementWrapper>)this.getProvider());
        if (!this.myNodes.contains((Object)node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
        if (domManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/diagram/SpringIntegrationDataModel", "getModificationTracker"));
        }
        return domManager;
    }

    public void dispose() {
    }
}

