/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SpringIntegrationMultiHostInjectorBase
implements MultiHostInjector {
    public final void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/integration/injection/SpringIntegrationMultiHostInjectorBase", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/integration/injection/SpringIntegrationMultiHostInjectorBase", "getLanguagesToInject"));
        }
        PsiFile containingFile = context.getContainingFile();
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            return;
        }
        Project project = containingFile.getProject();
        if (project.isDefault() || !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)containingFile))) {
            return;
        }
        this.performInjection(registrar, context);
    }

    protected abstract void performInjection(@NotNull MultiHostRegistrar var1, @NotNull PsiElement var2);

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/SpringIntegrationMultiHostInjectorBase", "elementsToInjectIn"));
        }
        return list;
    }
}

