/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml;

import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;

public class SpringIntegrationResourceProvider
implements StandardResourceProvider {
    public void registerResources(ResourceRegistrar registrar) {
        this.add20Namespaces(registrar);
        this.add20And21And22Namespaces(registrar);
        this.add21And22Namespaces(registrar);
        this.add22Namespaces(registrar);
        this.registerRabbitNamespaces(registrar);
    }

    private void add20Namespaces(ResourceRegistrar registrar) {
        RegistrarWorker worker20Only = new RegistrarWorker(registrar, (Class)this.getClass(), new String[]{"2.0"});
        worker20Only.add("httpinvoker");
    }

    private void add20And21And22Namespaces(ResourceRegistrar registrar) {
        RegistrarWorker worker20And21 = new RegistrarWorker(registrar, (Class)this.getClass(), new String[]{"2.0", "2.1", "2.2"});
        worker20And21.add("").add("feed").add("file").add("ftp").add("event").add("groovy").add("http").add("ip").add("jdbc").add("jms").add("jmx").add("mail").add("rmi").add("security").add("sftp").add("stream").add("twitter").add("ws").add("xml").add("xmpp");
    }

    private void add21And22Namespaces(ResourceRegistrar registrar) {
        RegistrarWorker worker21And22 = new RegistrarWorker(registrar, (Class)this.getClass(), new String[]{"2.1", "2.2"});
        worker21And22.add("amqp").add("gemfire").add("redis").add("scripting");
    }

    private void add22Namespaces(ResourceRegistrar registrar) {
        RegistrarWorker worker22Only = new RegistrarWorker(registrar, (Class)this.getClass(), new String[]{"2.2"});
        worker22Only.add("jpa").add("mongodb");
    }

    private void registerRabbitNamespaces(ResourceRegistrar registrar) {
        registrar.addStdResource("http://www.springframework.org/schema/rabbit/spring-rabbit-1.0.xsd", "/resources/schemas/rabbit/spring-rabbit-1.0.xsd", this.getClass());
        registrar.addStdResource("http://www.springframework.org/schema/rabbit/spring-rabbit-1.1.xsd", "/resources/schemas/rabbit/spring-rabbit-1.1.xsd", this.getClass());
    }

    private static class RegistrarWorker {
        private final ResourceRegistrar myRegistrar;
        private final Class myRegistrationClass;
        private final String[] myVersions;

        private RegistrarWorker(ResourceRegistrar registrar, Class registrationClass, String ... versions) {
            this.myRegistrar = registrar;
            this.myRegistrationClass = registrationClass;
            this.myVersions = versions;
        }

        private RegistrarWorker add(String componentName) {
            String schemaPrefix = componentName.isEmpty() ? "" : componentName + "/";
            String componentId = componentName.isEmpty() ? "" : "-" + componentName;
            for (String version : this.myVersions) {
                String schemaRelativeUrl = schemaPrefix + "spring-integration" + componentId + "-" + version + ".xsd";
                this.myRegistrar.addStdResource("http://www.springframework.org/schema/integration/" + schemaRelativeUrl, "/resources/schemas/" + schemaRelativeUrl, this.myRegistrationClass);
            }
            return this;
        }
    }
}

